from intranet.hrdb_ext.src.ispring.api.repository import BaseRepository
from intranet.hrdb_ext.src.ispring.api.pagination import XmlPage
import attr


@attr.s
class ISpringUser:
    user_id = attr.ib()
    department_id = attr.ib()
    login = attr.ib()
    first_name = attr.ib()
    last_name = attr.ib()

    @classmethod
    def from_xml(cls, root):
        fields = root.findall('.//field')
        fields_by_key = {
            field.find('name').text: field.find('value').text
            for field in fields
        }
        return cls(
            getattr(root.find('userId'), 'text', None),
            getattr(root.find('departmentId'), 'text', None),
            fields_by_key['LOGIN'],
            fields_by_key['FIRST_NAME'],
            fields_by_key['LAST_NAME'],
        )


class ISpringUserPage(XmlPage):
    item_key = 'userProfile'


class UserRepository(BaseRepository):
    page_cls = ISpringUserPage
    wrapper = ISpringUser
    resource = 'user'
