from django.core.management.base import BaseCommand
from intranet.hrdb_ext.src.ispring.sync.departments import CreateDepartments, UpdateDepartments, RemoveUnknownDepartments


TASKS = {
    'create': CreateDepartments,
    'update': UpdateDepartments,
    'delete': RemoveUnknownDepartments,
}


class Command(BaseCommand):
    def add_arguments(self, parser):
        parser.add_argument(
            'task',
            type=str,
            choices=['create', 'update', 'delete'],
        )
        parser.add_argument(
            '--staff_department_id',
            type=int,
            help='Staff department ID to synchronize',
        )
        parser.add_argument(
            '--ispring_root_id',
            type=str,
            help=(
                'Existing ISpring department ID, '
                'which will be parent for specified staff department'
            ),
        )

    def handle(self, *args, **options):
        self.stdout.write('Running task with options {}'.format(options))

        task_cls = TASKS[options['task']]
        task = task_cls(
            options['ispring_root_id'],
            options['staff_department_id'],
        )
        task.run()
