from intranet.hrdb_ext.src.ispring.mock.bucket import Bucket
from intranet.hrdb_ext.src.ispring.mock.resources import MockedUser, MockedDepartment
from intranet.hrdb_ext.src.ispring.api.connector import HttpConnector


class MockedConnector(HttpConnector):
    def __init__(self, users_count=5, departments_count=5, **kwargs):
        super(MockedConnector, self).__init__(**kwargs)

        self.users = Bucket(MockedUser, 'user_id')
        users = self.users.generate(count=users_count)

        self.departments = Bucket(MockedDepartment, 'department_id')
        departments = self.departments.generate(count=departments_count)

        for user, department in zip(users, departments):
            user.department_id = department.department_id

        self.history = []
        self.last_request = None
        self.count_requests = 0

    def log_request(self, **params):
        self.history.append(params)
        self.last_request = params
        self.count_requests += 1

    def reset(self):
        self.history = []
        self.last_request = None
        self.count_requests = 0

    def execute_request(self, method='get', resource=None, url_vars=None, **params):
        method = method.lower()
        self.log_request(method=method, resource=resource, url_vars=url_vars, **params)
        if 'department' in resource:
            return self.departments.handle(method, resource, url_vars, **params)
        elif 'user' in resource:
            return self.users.handle(method, resource, url_vars, **params)
        raise ValueError('Unknown resource')
