import logging
import traceback

logger = logging.getLogger(__name__)


class AbstractSyncTask:
    def __init__(self):
        self.requests = []
        self.is_executed = False
        self.is_failed = False

    def run(self):
        self.is_executed = True

        try:
            self.load()
            self.generate_requests()
            self.run_requests()
        except Exception as e:
            logger.error('Task {} failed: {}'.format(self, str(e)))
            logger.error(traceback.format_exc())
            self.is_failed = True
            raise e

    def load(self):
        pass

    def generate_requests(self):
        raise NotImplementedError

    def run_requests(self):
        raise NotImplementedError
