import traceback
from intranet.hrdb_ext.src.celery_app import app

from django.conf import settings
import logging
from intranet.hrdb_ext.src.lib.staff import get_repo
from intranet.hrdb_ext.src.ispring.sync.departments import CreateDepartments
from intranet.hrdb_ext.src.ispring.sync.departments import UpdateDepartments

logger = logging.getLogger(__name__)


@app.task()
def sync_ispring_departments():
    create_departments()
    update_departments()


def create_departments(config=None):
    config = config or settings.ISPRING_DEPARTMENTS_MAP_REGISTRY
    run_departments_task_with_config(CreateDepartments, config)


def update_departments(config=None):
    config = config or settings.ISPRING_DEPARTMENTS_MAP_REGISTRY
    run_departments_task_with_config(UpdateDepartments, config)


def run_departments_task_with_config(task_cls, config):
    config = config or settings.ISPRING_DEPARTMENTS_MAPPINGS
    logger.info('Running "{}" with config={}'.format(task_cls, config))

    repo = get_repo('group')

    for ispring_root, staff_roots in config.items():
        for staff_root_url in staff_roots:
            department = repo.get_one({'_fields': 'department.id', 'url': staff_root_url})
            if not department:
                logger.error('Unknown department in config: "{}"'.format(staff_root_url))
                continue

            staff_dep_id = department['department']['id']
            logger.info('Starting {}: "{}"->"{}"'.format(task_cls, ispring_root, staff_dep_id))

            try:
                task = task_cls(ispring_root, staff_dep_id)
                task.run()
            except Exception:
                logger.error(traceback.format_exc())
