from ids.registry import registry
from django.conf import settings
import itertools


def get_repo(resource):
    return registry.get_repository(
        service='staff',
        resource_type=resource,
        user_agent=settings.STAFF_API_USER_AGENT,
        oauth_token=settings.STAFF_API_OAUTH_TOKEN,
    )


def load_departments(include_deleted=False):
    is_deleted = 'false'
    if include_deleted:
        is_deleted = 'true,false'

    return get_repo('group').get({
        '_fields': ','.join([
            'url',
            'department.id',
            'department.name',
            'department.is_deleted',
            'ancestors.department.id',
            'is_deleted',
        ]),
        '_limit': 1000,
        'type': 'department',
        'is_deleted': is_deleted,
    })


def load_users(department_id, with_children=False, fields=None):
    repo = get_repo('group')
    fields = fields or [
        'login',
        'official.is_dismissed',
    ]
    lookup = {
        '_fields': ','.join(fields),
        '_limit': 1000,
    }

    root_users = repo.get({
        **lookup,
        'department_group.department.id': department_id,
    })

    if not with_children:
        return root_users

    child_users = repo.get({
        **lookup,
        'department_group.ancestors.department.id': department_id,
    })

    return itertools.chain(root_users, child_users)
