from django.views import View
from django.contrib.auth import authenticate
from django.http import HttpResponse
from django.contrib.auth import get_user_model


class ExternalAuthenticationView(View):
    # Need to ask our security team how to do this properly
    pass


class YandexAuthenticationView(View):
    def dispatch(self, request, *args, **kwargs):
        yandex_user = authenticate(request)
        if not yandex_user or not yandex_user.is_authenticated():
            return HttpResponse('Yauth failed', status=403)

        django_user = get_user_model().objects.filter(username=yandex_user.login)
        if not django_user.exists():
            return HttpResponse('Unknown user', status=403)

        request.user = django_user.first()
        return super(YandexAuthenticationView, self).dispatch(request, *args, **kwargs)
