from django.urls import include, path
from django.http import HttpResponse
from django.conf import settings
from django.contrib import admin


def home(request):
    return HttpResponse('OK')


urlpatterns = [
    path('', home),
    path('amo/', include('intranet.hrdb_ext.src.amo.urls')),
    path('admin/', admin.site.urls),
]

if settings.DEBUG:
    import debug_toolbar
    urlpatterns = [
        path('__debug__/', include(debug_toolbar.urls)),
    ] + urlpatterns
