# Добавить подтверждающего

## Кто может подтверждать роли {#who-can-confirmed}

Подтверждать [роли](https://doc.yandex-team.ru/idm/idm-guide/entities/user-role.html) могут только пользователи, добавленные в список [approvers](https://doc.yandex-team.ru/idm/idm-guide/entities/workflow.html). У каждой роли может быть несколько [подтверждающих](https://doc.yandex-team.ru/idm/idm-guide/entities/confirmer.html).

{% note info %}

Ответственные за [систему](https://doc.yandex-team.ru/idm/idm-guide/entities/system.html) или владелец системы также должны быть добавлены в список approvers. В противном случае они не смогут подтверждать роли.

{% endnote %}

## Уведомления на подтверждение роли {#notifications}

Отправка уведомлений на подтверждение роли зависит от условий workflow:
- Если подтверждение требуется от нескольких человек, IDM присылает запрос всем подтверждающим.
- Если достаточно подтверждения только одного человека, IDM присылает запрос первому по порядку подтверждающему.
- Если у подтверждающего на стаффе есть отметка об отсутствии (командировка, болезнь, обучение, отпуск), запрос отправляется следующему пользователю.
- Если отсутствуют все подтверждающие, письмо получат все пользователи из списка approvers.

#### Пример 

В workflow указано, что роль могут подтвердить Аня или Петя или Даша. Если Аня в отпуске, то письмо-уведомление будет отправлено Пете. Если и Петя отсутствует, то письмо получит Даша. Если отсутствует и Даша, письмо получат все ответственные.

## Добавить подтверждающего {#how-to}

Чтобы добавить подтверждающих роли в workflow вашей системы, выполните следующие действия:

1. Нажмите на ссылку с нужной системой на странице [**IDM. Все системы**](https://idm.yandex-team.ru/systems).
1. Перейдите на вкладку **Workflow**.
1. Нажмите кнопку **Редактировать** и выполните следующие действия:

   {% cut "Подтверждающим должен быть только один человек" %}
   
    Введите `approvers = ['логин']`

    **Пример**
    
    ```
    approvers = ['yuliya-k']
    ```
    {% endcut %}
	
	{% cut "Подтверждающих должно быть двое" %}
    
    Введите `approvers = ['логин_1', 'логин_2']`
	
    **Пример**
    ```
    approvers = ['yuliya-k', 'guitarman']
    ```
    {% endcut %}
	
	{% cut "Подтверждающих должно быть трое и более (при этом от одного из них подтверждение обязательно)" %}
    
    Введите `approvers = [any_from(['логин_1', 'логин_2']), 'логин_3']`
	
    **Пример**
    
    От yuliya-k подтверждение обязательно, от kaushina и guitarman опционально, но от одного из них — обязательно.
    
    ```
    approvers = [any_from(['kaushina', 'guitarman']), 'yuliya-k']
    ```
    {% endcut %}
	
	{% cut "Подтверждающих должно быть двое и более (при этом подтвердить может любой из них)" %}
    
    Введите `approvers = [any_from(['логин_1', 'логин_2', 'логин_3', 'логин_4'])]`
	
    **Пример**
    ```
    approvers = [any_from(['kaushina', 'guitarman', 'gentoonofb', 'yuliya-k'])]
    ```
    {% endcut %}
	
	{% cut "В качестве подтверждающего необходимо указать группу со Cтаффа" %}
    
    Введите `approvers = [any_from(groupify(идентификатор_группы_на_стаффе).get_all_responsibles())]`
	
    **Пример**
    ```
    approvers = [any_from(groupify(yandex_infra_tech_doc_dev).get_all_responsibles())]
    ```
    {% endcut %}
	
	{% cut "Подтверждающий для определенной роли" %}
    
    Роль можно проверять частично (например, только по названию) или полностью (учитывая название, тип, принадлежность к группе).
    
    Для полной проверки введите:
    ```
    if role ==  'данные_роли':
    approvers = ['логин_1']
    else:
    approvers = ['логин_2']
    ```
    Для частичной проверки введите:
    ```
    if role['role'] ==  'название_роли':
    approvers = ['логин_1']
    else:
    approvers = ['логин_2']
    ```
    
    **Примеры**
    
    При запросе роли «member» с типом «groups» в группе «yandex_infra_tech_doc_dev» запрос должен подтвердить guitarman, а все остальные запросы должен подтвердить yuliya-k.
    
    ```
    **if** role == {'type': 'groups', 'group': "yandex_infra_tech_doc_dev", 'role': 'member'}:
    approvers = ['guitarman']
    **else:**
    approvers = ['yuliya-k]
    ```
    
    При запросе роли «member» запрос должен подтвердить guitarman, а все остальные запросы должен подтвердить yuliya-k.
    ```
    **if** role['role'] == 'member':
    approvers = ['guitarman']
    **else:**
    approvers = ['yuliya-k]
    ```
    {% endcut %}
	
	{% cut "Подтверждающий для всех сотрудников, кроме исключений" %}
    
    Роль может быть предоставлена определенным сотрудникам без подтверждения, при этом для других сотрудников подтверждение будет обязательно.
	
    Чтобы создать список исключений, введите:
    
    ```
    **if** role == {'название_роли'}:
    **if** requester.username in ('login_1', 'login_2'):
    approvers = []
    **else:**
    approvers = ['login_3']
    ```
    
    **Пример**
    
    Если роль запрашивают сотрудники guitarman или yuliya-k, то подтверждение не требуется (роль выдается сразу), в противном случае подтверждение требуется от руководителя сотрудника.
    ```
    **if** role == {'role' : '5'}:
    **if** requester.username in (guitarman, yuliya-k):
    approvers = []
    **else:**
    approvers = [approver(boss_of(user))]
    ```
    {% endcut %}
	
	{% cut "Руководитель в качестве подтверждающего" %}
    
    - Если подтверждающим должен быть непосредственный руководитель сотрудника, руководитель другого подразделения или его заместитель, введите `approvers = [approver(boss_of(user)), get_head_of_or_zam('название_подразделения_на_стаффе')]`
    - Если подтверждающим должен быть непосредственный руководитель сотрудника и руководитель другого подразделения, введите `approvers = [approver(boss_of(user)), get_head_of('название_подразделения_на_стаффе')]`.
	
    {% note info %}
    
    Если подразделения не существует, не имеет руководителя или заместителя, сотрудник не сможет запросить роль.
    
    {% endnote %}
    
    **Пример**
    
    Подтверждение требуется от руководителя сотрудника, для которого запрашивается роль, а также от руководителя Финансового департамента (yandex_fin). Если руководитель Финансового департамента отсутствует, подтверждение требуется от его заместителя.
    ```
    **if** user.works_in_dep('yandex_fin_control') or user.works_in_dep('yandex_infra_int_support')
    approvers = []
    **else**:
    approvers = [approver(boss_of(user)), get_head_of_or_zam('yandex_fin')]
    ```
	
	{% endcut %}
    
1. Введите комментарий.
1. Нажмите кнопку **Применить изменения**.

## Поменять подтверждающего {#change-confirmer}

Чтобы поменять подтверждающего, выполните следующие действия:

1. Нажмите на ссылку с нужной системой на странице [**IDM. Все системы**](https://idm.yandex-team.ru/systems).
1. Перейдите на вкладку **Workflow**.
1. Нажмите кнопку **Редактировать**.
1. Удалите ненужный логин или добавьте новый в строке `approvers` .
1. Введите комментарий.
1. Нажмите кнопку **Применить изменения**.

