# Разрешить неконсистентности

{% include [entities-nonconsist](../_conref/conref/id-entities/nonconsist.md) %}


Подробное описание см. в разделе [Основные понятия](https://doc.yandex-team.ru/idm/idm-guide/entities/system.html) документа [IDM. Описание сервиса](https://doc.yandex-team.ru/idm/idm-guide/).

## Алгоритм определения неконсистентностей {#section_mmn_k3k_b1b}

IDM сравнивает свою таблицу ролей с таблицей системы.

Если для роли не была найдена пара, выполняется следующее: 
- Для роли, найденной в таблице IDM, но не найденной в таблице системы, заводится запись в таблице неконсистентностей. Роль получает статус «отозванная в результате разрешения неконсистентности». IDM приходит в консистентное состояние, так как с этого момента в обеих таблицах у пользователя нет такой активной роли.
- Для роли, найденной в таблице системы, но не найденной в таблице IDM, также заводится запись в таблице неконсистентностей. Роль получает статус «роль импортирована из системы». Запускается процесс подтверждения роли согласно [workflow](glossary.md#workflow-two) системы:
    - если роль не будет подтверждена в течение семи календарных дней, IDM отзовет эту роль из системы и придет в консистентное состояние;
    - если роль подтвердят, IDM также придет в консистентное состояние, так как с этого момента в обеих таблицах у пользователя будет существовать эта роль.

Если для роли была найдена пара, запись в таблице неконсистентностей не заводится.

## Способы разрешения неконсистентностей {#section_iwh_l3k_b1b}

Полный список неконсистентностей представлен на [странице вашей системы](https://doc.yandex-team.ru/idm/idm-guide/entities/system.html) на вкладке **Неконсистентности**.

Способ разрешения неконсистентности зависит от ее типа.

#|
||Неконсистентность | Решение||
||Тип еще не определен | Напишите на рассылку [tools@yandex-team.ru](tools@yandex-team.ru).||
||У нас есть роль, в системе - нет | Если удаленная роль все еще актуальна, добавьте ее обратно в систему. А затем напишите на рассылку [tools@yandex-team.ru](tools@yandex-team.ru) для синхронизации базы ролей пользователей в IDM с базой системы. 
Если роль не актуальна — напишите на рассылку [tools@yandex-team.ru](tools@yandex-team.ru) запрос с просьбой удалить эту роль из IDM.||
||В системе есть роль, а у нас - нет | Если роль актуальна, необходимо синхронизировать базы ролей пользователей в IDM с базой системы. Для этого напишите на рассылку [tools@yandex-team.ru](tools@yandex-team.ru). 
Если роль не актуальна — удалите роль из базы вашей системы.||
||В системе есть роль, но она отсутствует в дереве ролей системы | Синхронизируйте копию узлов дерева ролей в IDM с деревом ролей системы:
1. Откройте страницу системы.
    Список систем, подключенных к IDM, представлен на странице [**IDM. Все системы**](https://idm.yandex-team.ru/systems).
    
1. Перейдите на вкладку **Синхронизация**.
1. Нажмите кнопку **Синхронизировать** в блоке **Узлы**.||
||В системе имеется пользователь, о котором мы не знаем | IDM работает только с базой [Стаффа](https://staff.yandex-team.ru/). 
Чтобы решить проблему, необходимо добавить пользователя на Стафф или удалить его из системы.||
||В системе имеется группа, о которой мы не знаем | IDM работает только с группами Staff API (группы Стаффа и сервиса ABC).
Удалите существующую роль, затем создайте новую и прикрепите ее к группе на Стаффе.||
|#

Дополнительную информацию см. в разделе [Алгоритмы](https://doc.yandex-team.ru/idm/idm-guide/algorithm/nonconsist.html) документа [IDM. Описание сервиса](https://doc.yandex-team.ru/idm/idm-guide/).

