# Возвращаемые результаты

Раздел содержит список кодов ответов и ошибок, возвращаемых методами `GET` и `POST`.

Ответы возвращаются в формате JSON и имеют единую структуру:

```
HTTP/1.1 <код_состояния>
Content-Type: application/json
X-Request-ID: <id ответа>
...
{json-object} 
```

## Заголовки {#section_nmg_lv3_ycb}

Ответы API сопровождаются обязательными HTTP-заголовками:
- `Content-Type` — формат данных тела ответа.
- `X-Request-ID` — уникальный идентификатор ответа.

## Коды состояния {#section_mpy_ybt_xcb}

| Код                         | Описание                                                                       |
|-----------------------------|--------------------------------------------------------------------------------|
| `200 OK`                    | Запрос успешно выполнен.                                                       |
| `500 Internal Server Error` | Внутренняя ошибка сервиса. IDM повторно отправит запрос через некоторое время. |


Если в ответе указан иной код, JSON-документ должен содержать поля `warning`, `error` или `fatal` с текстовым предупреждением или описанием ошибки. Подробное описание полей см. в таблице ниже.

#|
||Поле | Описание | Формат||
||`code` | HTTP-статус выполненного запроса. | Строка||
||`warning` | Причина и тип предупреждения. 

Результат считается успешным. | Строка||
||`error` | Причина и тип ошибки. 

IDM повторно отправит запрос через некоторое время. | Строка||
||`fatal` | Причина и тип фатальной ошибки. | Строка||
|#

## Формат ответа {#section_brx_zzj_wcb}

```
{
  "code": < int >,
 ...
}
```

## Примеры {#section_lmx_xpq_wcb}

#### Успешное выполнение

```
{
"code": 0
...
} 
```

#### Предупреждение

```
{
"code": 1 
"warning": "Пользователь уже имеет эту роль."
}
```

#### Ошибка

```
{
"code": 1
"error": "Нет связи с базой данных."
}
```

#### Фатальная ошибка

```
{
"code": 1
"fatal": "Нет такой роли."
}
```

