# Глоссарий

### Active Directory  {#ad}
Active Directory (AD) — корпоративные службы каталогов для операционных систем семейства Windows Server.

### X-Request-ID {#X-Request-ID}
Уникальный идентификатор ответа.

### Workflow {#workflow}
Процесс предоставления доступа пользователям.

### Workflow {#workflow-two}

Различные сценарии, выполняемые в системе.

В workflow обязательно должен быть определен список подтверждающих роли (`approvers`). Список может быть либо пустым, либо содержать логины сотрудников, от которых требуется получить подтверждение. Роль считается подтвержденной, если получено одобрение хотя бы от одного сотрудника из списка.

Workflow описывается на языке Python. Изменения в workflow вносит либо сотрудник со стороны системы, либо сотрудник [Службы информационной безопасности](https://staff.yandex-team.ru/departments/yandex_mnt_security/). Полное описание всех переменных и функций представлено в разделе [Справочник workflow](workflow-list.md) документа [IDM. Руководство владельца системы](../index.md).

#### Примеры сценариев

- [получать подтверждение](add-confirmer.md) сотрудника или нескольких сотрудников при запросе роли;
- [отправлять уведомления](notifications.md) сотрудникам, подтверждающим роль;
- [показывать предупреждение](vista.md#warning) при запросе роли;
- [учитывать роли](vista.md#has_role) пользователя в других системах.

### Пользовательская роль {#user-role}

Уровень доступа сотрудника к какой-либо системе, подключенной к IDM.

В IDM существует несколько пользовательских ролей:
- **Персональная**. Выдается отдельному [пользователю](https://doc.yandex-team.ru/idm/idm-guide/entities/user.html).
- **Групповая**. Выдается на [группу](https://doc.yandex-team.ru/idm/idm-guide/entities/group.html), в которой состоит пользователь. Все участники группы получают связанную персональную роль. Если пользователь покидает группу, по истечении семи дней роль автоматически отзывается. В [списке ролей](https://idm.yandex-team.ru/) групповую роль можно определить по значку с типом группы ![](https://doc.yandex-team.ru/idm/idm-guide/image/role-types.png). Если нажать на значок, откроется карточка роли, выданной на группу (не на пользователя).

Каждой роли соответствует один из статусов:
- **Активные** — подтвержденные роли пользователя.
- **Неактивные** — отозванные, просроченные или отклоненные роли.
- **Запрошенные** — роли, которые были запрошены, но еще не подтверждены.

У каждой пользовательской роли есть название. Владелец и ответственные [системы](https://doc.yandex-team.ru/idm/idm-guide/entities/system.html) самостоятельно задают названия ролей и текстовые подсказки к ним. Если из названия вам непонятно предназначение роли, обратитесь к владельцу системы.

Список всех выданных ролей хранится в базе подключенной системы, а в  базе IDM хранится копия этого списка.

### aliases {#aliases}
Синонимы ролей в одном узле дерева. Если роль описывается несколькими синонимами, позволяет найти роль по каждому из них. 

### code {#code}
HTTP-статус выполненного запроса.

### choices {#choices}
Варианты выбора в ключе `options`. 

### context {#context}
Секретные данные (например, пароли). Все данные словаря передаются, но не сохраняются в базе IDM. 

### content-type {#content-type}
Формат данных тела ответа.

### custom {#custom}
Определяет возможность добавить свой вариант ответа в пользовательском интерфейсе. Используется для ключа `options`. Возможные значения: `true` и `false`.

### data {#data}
Блок с дополнительными данными о роли. Передается в ответ на запрос POST /add-role/.

### deleted {#deleted}
Параметр передается для удаленных групп (только для [систем group-aware](#group-aware)). 

### error {#error}
Причина и тип ошибки. IDM повторно отправит запрос через некоторое время. 

### fatal {#fatal}
Причина и тип фатальной ошибки.

### fields {#fields}
Дополнительные данные о роли. Каждое поле обязательно содержит словари: [`name`](#name), [`slug`](#slug), [`type`](#type), [`required`](#required).

### firewall-declaration {#firewall-declaration}
Дополнительные правила сетевого экрана (firewall) для соответствующей роли или группы ролей. 

### group {#group}
Идентификатор (id) группы на [Стаффе](https://staff-api.yandex-team.ru/v3/) (в ключе `groups` только для [систем group-aware](#group-aware)). 

### group  {#group-key-roles}
Название группы в ключе `roles`.

### group-aware {#group-aware}
Системы, использующие групповые роли и самостоятельно отслеживающие состав групп. 

### group-unaware {#group-unaware}
Системы, которые используют групповые роли, но не отслеживают состав групп. 

### groups {#groups_two}
Блок со списком групп и выданных ролей на эту группу. Системы [group-unaware](#group-unaware) могут не передавать ключ `groups`.

### help {#help}
Дополнительная информация о роли в поле `values`. 

### fired {#fired}
Параметр передается для уволенного пользователя.

### login {#login}
Логин пользователя со [Стаффа](https://staff-api.yandex-team.ru/v3/). 

### name {#name}
Понятное описание или название параметра, которое пользователь видит в форме запроса роли (например, роль «модератор»). 

### next-url {#next-url}
Адрес следующей страницы со списком пользователей и ролей.

### notify {#notify}
Определяет, необходимо ли отправлять уведомления ответственному за роль. Возможные значения: `true` и `false`. Используется в ключе `responsibilities`.

### options {#options}
Блок с вариантами для выбора в поле `choicefield`. 

### path {#path}
Путь узла в дереве ролей. 

### passport-login {#passport-login}
[Паспортный логин](#passport-login-ru) пользователя. 

### set {#set}
Объединяет однотипные доступы (роли) в наборы. Используется для систем, в которых существуют одинаковые роли в разных ветвях дерева. 

### slug {#slug}
Уникальное название параметра, которое передается обратно в систему при запросе роли. Используется формат, который может быть прочитан человеком.

### status {#status}
Статус выполненного запроса.

### type {#type}
Тип поля

### responsibilities {#responsibilities}
Список ответственных за управление узлами в пределах одной ветки дерева.

### required {#required}
Определяет, является ли поле обязательным или нет. Возможные значения: `true` и `false`.

### role {#role}
Спецификация роли. 

### roles {#roles}
Блок со списком всех ролей пользователя или группы.

### unique_id {#unique_id}
Уникальный идентификатор узла дереве. Используется для перемещения узлов дерева со всеми привязанными к ним ролями.

### users {#users}
Блок со списком логинов пользователей и выданных им ролей.

### values {#values}
Словарь узлов и соответствующих им значений. Узел может содержать расширенное описание, которое пользователь увидит в виде подсказки на этапе запроса роли в IDM. Для этого в поле `values` добавляются дополнительные словари: `name`, `visibility`, `help`.

### visibility {#visibility}
Видимость роли или узла дерева в пользовательском интерфейсе IDM. 
 
### warnings {#warnings}
Причина и тип предупреждения. Результат считается успешным. 

### widget {#widget}
Определяет вид переключателя в ключе `options`. Возможные значения: `radio` и `select`.

### Группа {#groups}
Группой в IDM считается подразделение внутри компании, команда внутри сервиса ABC или вики-группа.

### Неконсистентность {#nonconsist}
Расхождение в таблице ролей IDM и таблице ролей любой подключенной системы.

### Паспортный логин {#passport-login-ru}
Идентификатор сотрудника (пользователя). К паспортному логину привязывается роль.

### Подтверждающий {#confirmer}

Пользователь, от которого необходимо получить подтверждение для получения роли.

#### Кто может подтверждать роли {#who-can-confirmed}

Подтверждать [роли](https://doc.yandex-team.ru/idm/idm-guide/entities/user-role.html) могут только пользователи, добавленные в список [approvers](https://doc.yandex-team.ru/idm/idm-guide/entities/workflow.html). У каждой роли может быть несколько [подтверждающих](https://doc.yandex-team.ru/idm/idm-guide/entities/confirmer.html).

{% note info %}

Ответственные за [систему](https://doc.yandex-team.ru/idm/idm-guide/entities/system.md) или владелец системы также должны быть добавлены в список approvers. В противном случае они не смогут подтверждать роли.

{% endnote %}

#### Уведомления на подтверждение роли {#notifications}

Отправка уведомлений на подтверждение роли зависит от условий workflow:
- Если подтверждение требуется от нескольких человек, IDM присылает запрос всем подтверждающим.
- Если достаточно подтверждения только одного человека, IDM присылает запрос первому по порядку подтверждающему.
- Если у подтверждающего на стаффе есть отметка об отсутствии (командировка, болезнь, обучение, отпуск), запрос отправляется следующему пользователю.
- Если отсутствуют все подтверждающие, письмо получат все пользователи из списка approvers.

#### Пример

В workflow указано, что роль могут подтвердить Аня или Петя или Даша. Если Аня в отпуске, то письмо-уведомление будет отправлено Пете. Если и Петя отсутствует, то письмо получит Даша. Если отсутствует и Даша, письмо получат все ответственные.

### Ручки {#ruchki}
HTTP-запросы, с помощью которых система взаимодействует с серверами IDM.

### Система {#system}
Сервис, подключенный к IDM. Список подключенных систем представлен на странице [IDM. Все системы](https://idm.yandex-team.ru/systems).

