# Информация о системе и ролях (info)

Возвращает информацию о системе и доступных ролях.

## Синтаксис запроса {#section_ej3_lvc_wcb}

```
GET https://{адрес запрашиваемого ресурса}/info
```

## Описание полей ответа {#section_pq1_qjj_wcb}

В ответе системы на запрос IDM могут содержаться следующие поля:

#|
||Поле | Описание | Тип данных||
||`slug` | Уникальное название роли, которое будет передано обратно в систему при ее запросе. 
Может содержать латинские буквы, цифры, знак подчеркивания и дефис.

Запрещено менять название для доступов и использовать одинаковое название в разных частях дерева. | Строка||
||`roles` | Блок со списком всех ролей. | Объект||
||`name` | Понятное описание или название роли, которое пользователь видит в форме запроса (например, роль «модератор»). При использовании в словаре `values` параметр обязательно должен содержать ключи `ru` и `en` (при запросе роли пользователь увидит название роли на языке, который включен в настройках интранета). | Строка||
||`values` | Словарь узлов и соответствующих им значений. 
Узел может содержать расширенное описание, которое пользователь увидит в подсказке при запросе роли в IDM. Для этого в поле `values` добавляются дополнительные словари: [`name`](glossary.md#name), [`visibility`](glossary.md#visibility), [`help`](glossary.md#help) - Дополнительная информация о роли в поле `values`. | Массив||
||`visibility` | Видимость роли или узла дерева в пользовательском интерфейсе IDM. Возможные значения: `true` и `false`. Может применяться как для роли, так и для отдельного узла дерева. | Логическое||
||`firewall-declaration` | Дополнительные правила динамического сетевого экрана (firewalll) для соответствующего узла в дереве ролей.

{% cut "Подробнее" %}

Правила динамического сетевого экрана применяются в момент, когда пользователь получает IP-адрес. Правила определяют, возможен ли доступ в [систему](glossary.md#system)  с рабочего ноутбука сотрудника. 
Правила формируются через сервис [Puncher](https://puncher.yandex-team.ru/). 

{% endcut %}

| Строка||
||`responsibilities` | Список ответственных за управление узлами в пределах одной ветки дерева. Логины ответственных указываются во вложенном ключе `username`.
Перед использованием параметра напишите на рассылку [tools@yandex-team.ru](tools@yandex-team.ru). | Массив||
||`username` | Логин пользователя со [Стаффа](https://staff-api.yandex-team.ru/v3/). Используется в ключе `responsibilities`. | Строка||
||`notify` | Необходимость отправки уведомлений ответственному за роль в ключе `responsibilities`. Возможные значения: `true` и `false`. | Логическое||
||`login` | Доменный логин пользователя. | Строка||
||`fields` | Дополнительные данные.

Обязательно содержит словари: [`name`](glossary.md#name), [`slug`](glossary.md#slug), `[type](glossary.md#type)`, `[required](glossary.md#required)`.

Может использоваться на любом уровне в иерархии дерева ролей. | Массив||
||`type` | Тип поля `fields`. Возможные значения: 
- `passportlogin` — поле для ввода [паспортного логина](glossary.md#passport-login-ru).
- `charfield` — текстовое поле.
- `booleanfield` — булево поле. В пользовательском интерфейсе IDM представлено в виде опции («check box»).
- `choicefield` — поле для выбора нескольких вариантов. В пользовательском интерфейсе IDM представлено в виде переключателя. Чтобы добавить варианты для выбора, необходимо задать ключ `options`.
- `inner_name` — текстовое поле, имя внутри системы. Пользователь задает имя самостоятельно.

Если поле `type` не заполнено, поле считается текстовым. | Строка||
||`required` | Обязательность поля. Возможные значения: `true` и `false`. | Логическое||
||`options` | Блок с вариантами для выбора в поле `choicefield`. | Массив||
||`widget` | Вид переключателя в ключе `options`. Возможные значения: `radio` и `select`. | Логическое||
||`choices` | Варианты выбора для значений `options`. | Массив||
||`help` | Дополнительная информация о роли в поле `values`. Обязательно содержит ключи `ru` и `en` (при запросе роли пользователь увидит информацию о роли на языке, который включен в настройках интранета). | Массив||
||`custom` | Возможность добавить свой вариант ответа в пользовательском интерфейсе. Используется для ключа `options`. Возможные значения: `true` и `false`. | Строка||
||`unique_id` | Уникальный идентификатор узла дереве. 
Используется для перемещения узлов дерева со всеми привязанными к ним ролями. 

{% cut "Подробное описание" %}

Перемещение узла дерева — удаление узла в старом месте с отзывом всех привязанных к нему ролей и добавление узла в новом месте. Если задать `unique_id`, то при сверке дерева ролей IDM обнаружит, что в другой ветке появился узел с таким же `unique_id`. IDM не удалит узел, а переместит его со всеми привязанными ролями. 

{% endcut %}

| Строка||
||`aliases` | Синонимы ролей в одном узле дерева. 
Если роль описывается несколькими синонимами, позволяет найти роль по каждому из них. | Массив||
||`set` | Объединяет однотипные доступы (роли) в наборы.
Используется для систем, в которых существуют одинаковые роли в разных ветвях дерева. | Строка||
|#

## Пример запроса {#section_kr3_gct_xcb}

```

GET https://doc-test.tools.yandex-team.ru/client-api/info/
```

## Примеры ответов {#section_qlw_c2j_wcb}

{% cut "Пример ответа с простым узлом" %}

В систему входит две группы пользователей: «модератор» и «администратор».

```
{
  "code": 0,
  "roles": {
    "slug": "group",
    "name": "группа",
    "values": {
      "moderator": "модератор",
      "admin": "администратор",
    },
  },
}
```

{% endcut %}

{% cut "Пример ответа с иерархическим узлом" %}

В систему входит несколько проектов: «подписки», «IDM», «секретчики». Для проекта «секретчики» используется параметр `visibility`, поэтому проект не отображается в пользовательском интерфейсе IDM, однако доступен для запроса через API IDM.

В рамках каждого проекта у пользователя могут быть разные роли. В форме запроса пользователь сначала выбирает проект, затем роль. Например, если выбрать проект «IDM», то в списке ролей можно выбрать «администратор» или «аудитор».

```
{
  "code": 0,
  "roles": {
    "slug": "project",
    "name": {"ru": "проект", "en": "project"},
    "values": {
        "subs": {
         "name": {"ru": "подписки", "en": "subscriptions"},
        "roles": {
           "slug": "role",
           "name": {"ru": "роль", "en": "role"},
           "values": {
              "developer": {"ru": "разработчик", "en": "developer"},
              "manager": {"ru": "менеджер", "en": "manager"},
            }
          },
        },
        "rules": {
           "name": "IDM",
          "roles": {
            "slug": "role",
            "name": {"ru": "роль", "en": "role"},
            "values": {
              "admin": {"ru": "администратор", "en": "administrator"},
              "auditor": {"ru": "аудитор", "en": "auditor"},
            }
          },
        },
        "secret_group": {
          "name": {"ru": "Секретчики", "en": "Infosec"},
          "visibility": false,
          "roles": {
            "slug": "role",
            "name": {"ru": "роль", "en": "role"},
            "values": {
              "kgb": {"ru": "кгбэшник", "en": "kgb"},
              "cia": {"ru": "црушник", "en": "cia"},
              "mi6": {"ru": "мишестьник", "en": "mi6"},
            }
          },
        },
    },    
    // Другие проекты, могут содержать другие роли
  }
}
```
{% endcut %}

{% cut "Пример с расширенным описанием узлов" %}

Узел содержит расширенное описание, которое пользователь увидит в виде подсказки на этапе запроса роли в IDM. Для этого в поле `values` добавлены словари с параметрами `name`, `help`, `visibility`.

В системе существует три роли: «moderator», «admin», «secret». Роль «secret» не отображается в пользовательском интерфейсе IDM, однако доступна для запроса через API IDM.
```
{
  "code": 0,
  "roles": {
    "slug": "group",
    "name": "группа",
    "values": {
      "moderator": {
       "name": {
             "ru": "Модератор",
             "en": "Moderator",
          }
          "help": {
             "ru": "Может банить и скрывать посты пользователей",
             "en": "Has permissions to ban users and hide their posts"
          }
      },
      "admin": {
      "name": {
            "ru": "Администратор",
            "en": "Administrator"
         }
      "help": {
            "ru": "Может добавлять модераторов, удалять посты, изменять настройки системы",
            "en": "Can add moderators, delete posts, change system's settings"
         }
      },
      "secret": {
      "name": "Secret role",
      "help": "только для тех, кто знает о ней",
         "visibility": false
       },
    },
  },
}
```
{% endcut %}

{% cut "Пример ответа с дополнительными правилами сетевого экрана" %}

Для всех пользователей, которым выдана роль `{"project": "subs", "role": "developer"}` или `{"project": "subs", "role": "manager"}`, применяются дополнительные правила `"subs-firewall"`.

Для всех пользователей, которым выдана роль `{"project": "rules", "role": "admin"}`, применяются дополнительные правила `"rules-admin-firewall"`.

```
{
  "code": 0,
  "roles": {
    "slug": "project",
    "name": "проект",
    "values": {
        "subs": {
          "name": "подписки",
          "firewall-declaration": "subs-firewall",
          "roles": {
            "slug": "role",
            "name": "роль",
            "values": {
              "developer": "разработчик",
              "manager": "менеджер",
            }
          },
        },
        "rules": {
         "name": "IDM",
        "roles": {
            "slug": "role",
            "name": "роль",
            "values": {
              "admin": {
                "name": "администратор",
                "firewall-declaration": "rules-admin-firewall",
              },
              "auditor": "аудитор",
            }
          },
        },
    },    
    // Другие проекты, могут содержать другие роли
  }
}
```

{% endcut %}

{% cut "Пример ответа со списком ответственных за узел" %}

Сотрудники с логинами «login1» и «login2» являются ответственными за узел «разработчик».
Флаг `notify` хранится в системе, но не используется и не интерпретируется.

```
{
  "code": 0,
  "roles": {
    "slug": "project",
    "name": "проект",
    "values": {
        "proj1": {
          "name": {"ru": "Проект 1", "en": "Project 1"},
          "roles": {
            "slug": "role",
            "name": {"ru": "Роль", "en": "Role"},
            "values": {
              "developer": {
                "name": {"ru": "разработчик", "en": "developer"},
                 "responsibilities": [
                     {
                        "username": "login1",
                        "notify": True,
                     }, {
                        "username": "login2",
                        "notify": False,
                     }
                 ]
              }
            }
          },
        }
    },    
  }
}
```
{% endcut %}

{% cut "Пример ответа с дополнительными параметрами" %}

Пользователь обязательно должен выбрать паспортный логин, к которому привязывается роль (`"slug": "passport-login"`). Также пользователь может задать свое имя внутри системы (`"slug": "inner_name"`). В ключ `options` добавлены варианты выбора: «Для королей эльфов», «Для королей гномов», «Для людей», «Для Саурона». В пользовательском интерфейсе IDM варианты доступны в виде переключателя. Пользователь также может добавить свой собственный вариант, для этого в ключ `options` добавлен ключ `custom` со значением `true`.
```
{
  "code": 0,
  "roles": {
    "slug": "group",
    "name": "группа",
    "values": {
      "moderator": "модератор",
      "admin": "администратор",
    },
  },
  "fields": [
      {
         "slug": "passport-login",
         "name": {
            "ru": "Паспортный логин",
            "en": "Passport login",
         }, 
         "type": "passportlogin",
         "required": true
      },
      {
         "slug": "inner_name",
         "name": {
            "ru": "Имя внутри системы",
            "en": "Inner name",
         },
         "type": "choicefield",
         "required": true
         "options": {
             "widget": "radio",
             "custom": true,
               "choices": [
        {
            "value": "elvenkings",
            "name": {
                "en": "For Elven-kings",
                "ru": "Для королей эльфов",
            }
        },
        {
            "value": "dwarflords",
            "name": {
                "en": "For Dwarf Lords",
                "ru": "Для королей гномов",
            }
        },
        {
            "value": "mortalmen",
            "name": {
                "en": "For mortal men",
                "ru": "Для людей",
            },
        },
        {
            "value": "darklord",
            "name": {
                "en": "For dark lord",
                "ru": "Для Саурона",
            }
        }
    ]
}
```

{% endcut %}

{% cut "Пример ответа с синонимами ролей" %}

В узле `Проект 1` для роли «разработчик» заданы синонимы в поле `aliases`: «программист», «разработчик».

```
{
"code": 0,
  "roles": {
    "slug": "project",
    "name": "проект",
    "values": {
        "proj1": {
          "name": {"ru": "Проект 1", "en": "Project 1"},
          "roles": {
           "slug": "role",
           "name": {"ru": "Роль", "en": "Role"},
           "values": {
              "developer": {
                "name": {"ru": "разработчик", "en": "developer"},
                 "aliases": [
                     {
                        "type": "default",
                        "name": {
                           "ru": "программист",
                           "en": "programmer",
                        }
                     }, {
                        "type": "default",
                        "name": {
                           "ru": "разработчик",
                           "en": "developer"
                        }
                     }
                 ]
              }
            }
          },
        }
    },    
  }
}
```

{% endcut %}

{% cut "Пример ответа с доступами, объединенными в наборы" %}

В системе существуют проекты `proj1` и `proj2`. В каждом проекте существуют однотипные роли «разработчик» и «менеджер». Эти роли объединены в набор с помощью параметра `set`. 
```
{
  "code": 0,
  "roles": {
    "slug": "project",
    "name": "проект",
    "values": {
        "proj1": {
          "name": {"ru": "Проект 1", "en": "Project 1"},
         "roles": {
            "slug": "role",
            "name": {"ru": "Роль", "en": "Role"},
            "values": {
              "developer": {
                 "set": "developer",
                "name": {"ru": "разработчик", "en": "developer"},
              }
              "manager": {
              "set": "manager",
             "name": {"ru": "менеджер", "en": "manager"},
              }
            }
          },
        },
        "proj2": {
       "name": {"ru": "Проект 2", "en": "Project 2"},
       "roles": {
        "slug": "role",
          "name": {"ru": "Роль", "en": "Role"},
          "values": {
              "developer": {
                 "set": "developer",
                "name": {"ru": "разработчик", "en": "developer"},
              }
              "manager": {
                "set": "manager",
               "name": {"ru": "менеджер", "en": "manager"},
              }
            }
          },
        },
    },    
  }
}
```
{% endcut %}
