# Список пользователей и ролей (get-roles)

Выдает список пользователей и ролей для сверки и синхронизации данных между БД системы и БД IDM.

При использовании запроса `get-roles` информация о ролях передается по сети в нескольких JSON-документах. Запрос может быть использован для систем с большим количеством ролей. 

{% note info %}

Система должна обеспечивать консистентность передаваемых данных. То есть данные, которые система передает IDM, должны представлять собой слепок списка ролей в системе на момент синхронизации данных.

{% endnote %}

## Синтаксис запроса {#section_brx_zzj_wcb}

```
GET https://{адрес запрашиваемого ресурса}/get-roles
```

## Описание полей ответа {#section_kzm_11k_wcb}

В ответе могут содержаться следующие поля: 

#|
||Поле | Описание | Тип данных||
||`next-url` | Адрес следующей страницы со списком пользователей и ролей.

{% cut "Ограничения" %}

Если в поле `next-url` передается абсолютный путь с префиксом протокола (https://...), то его хост и порт должны совпадать с хостом и портом базового адреса системы. Если в поле `next-url` не передается абсолютный путь с префиксом протокола (https://...), то полный адрес вычисляется как слияние хоста и порта из базового адреса системы и значения, переданного в поле `next-url`. 

{% endcut %}

| Строка||
||`roles` | Блок со списком пользователей и ролей. | Массив||
||`path` | Путь узла в дереве ролей. | Строка||
||`login` | Логин пользователя со [Стаффа](https://staff-api.yandex-team.ru/v3/). 

{% include [entities-get-roles](../_includes/concepts/conref/id-entities/get-roles.md) %} 

| Строка||
||`fields` | Дополнительные данные о роли. Подробнее см. раздел [Информация о системе и ролях](idm-get-info.md). | Массив||
||`passport-login` | [Паспортный логин](glossary.md#passport-login-ru) пользователя. | Строка||
||`group` | Идентификатор (id) группы на [Стаффе](https://staff-api.yandex-team.ru/v3/). 

{% include [entities-get-roles](../_includes/concepts/conref/id-entities/get-roles.md) %} 

| Строка ||
|#

## Пример запроса {#section_mpy_ybt_xcb}

```

GET https://doc-test.tools.yandex-team.ru/client-api/get-roles/
```

## Пример ответа {#section_lmx_xpq_wcb}

```
{
  "code": 0,
  "next-url": "/path/to/next-data?with=params",
  "roles": [
    {
      "path": "/path/to/role/node1/",
      "login": "username1"
    },
    ...
    {
      "path": "/path/to/role/node2/",
      "login": "username2",
      "fields": {
        "passport-login": "yndx-username2"
      }
    }
    ... 
    {
       "path": "/path/to/role/node2/",
       "group": 256
    }
    ...
   ]
}
```

