# Разработать API системы

При подключении системы к IDM необходимо разработать  и API системы для интеграции с IDM.

## Работа с API {#section_oj2_vfc_wcb}

IDM обращается к API системы через четыре HTTP-запроса и перезаписывает дерево ролей в том виде, в котором оно существует в БД системы.

Все, чем можно управлять через API, представлено в виде ресурсов: узлы, списки ролей, списки пользователей. То есть ресурс — это целостная часть системы, которая позволяет:

- предоставлять информацию о системе и доступных ролях (запрос [/info/](idm-get-info.md));
- выдавать список пользователей и ролей для сверки и синхронизации данных (запрос [ /get-all-roles/](idm-get-all-roles.md));
- удалять роль из БД (запрос [/remove-role/](idm-post-remove-role.md));
- добавлять роль в БД (запрос [/add-role/](idm-post-add-role.md)).

У каждого ресурса имеется собственный адрес (URL). Все действия выполняются соответствующими методами протокола HTTP на адреса этих ресурсов. Системы обмениваются с IDM информацией в формате JSON.

## Аутентификация по сертификату {#section_xv4_ngc_wcb}

Системы, реализующие API, должны предоставлять серверный сертификат по HTTPS и требовать клиентский сертификат, подписанный Яндексом. Подробнее см. страницу [IDM : Проверка клиентского SSL сертификата](https://wiki.yandex-team.ru/Intranet/idm/security/https/) (wiki).

