# Приложение 1. Политики системы

При подключении системы к IDM можно указать правила (политики), согласно которым система будет работать.

{% note alert %}

Для некоторых систем администраторы IDM могут скорректировать свойства для указанных вами политик. Это связано с требованиями внешних регуляторов (например, SOX).

{% endnote %}

## Политика системы в отношении внешних паспортных логинов (@yandex.ru) {#politics}

Политика используется для систем, в которых роль привязывается к **внешним** паспортным логинам вида «префикс yndx-» + «доменный_логин@yandex.ru» (например, yndx-yuliya-k@yandex.ru).

|Правило | Описание
|----- | -----
|Нет ограничений на количество внешних паспортных логинов у пользователя или количества ролей, связанных с логином | Сотрудник может использовать любое количество логинов. На каждый логин может быть выдано любое количество ролей.
|Один внешний паспортный логин для всех ролей каждого пользователя системы | Сотрудник может использовать только один логин. На этот логин может быть выдано любое количество ролей.

## Политика системы в отношении групп {#group}

#|
|| **Правило** | **Описание** ||
||Система не поддерживает групповые роли | Роль в системе можно выдавать только на отдельного сотрудника.

Правило обязательно для систем, в которых используются персональные настройки (например, в которых роль привязывается к паспортному логину).||
||Система поддерживает групповые роли, но сама про группы ничего не знает | IDM выдает роль в системе на группу и самостоятельно отслеживает состав групп.

Высылает в систему только push-уведомления по логинам, которые получили роль и входят в группу.

Пример:

1. Сотрудник запрашивает роль на группу.
1. IDM собирает все подтверждения на выдачу этой роли.
1. Когда все подтверждения получены, роль переводится в состояние «Выдана».
1. IDM начинает поиск всех сотрудников из группы и выдает персональную связанную роль каждому из них.
1. IDM отправляет push-уведомления по каждому логину в систему.
    Если система подтверждает выдачу роли (возвращает ответ «OK»), роль становится активной.
    
    В противном случае роль переводится в состояние «Ошибка».||
||Система поддерживает групповые роли и сама следит за составом групп | Система самостоятельно принимает решение о выдаче роли сотруднику из группы.

Пример: 
1. Сотрудник запрашивает роль на группу.
1. IDM собирает все подтверждения на выдачу этой роли.
1. Когда все подтверждения получены, роль переводится в состояние «Подтверждена».
1. IDM отправляет push-уведомление с названием группы в систему.
1. Система решает, выдавать роль по каждому логину из этой группы или не выдавать:
    - Если система подтверждает выдачу роли (возвращает ответ «OK»), роль становится активной.
    - В противном случае роль переводится в состояние «Ошибка».||
|#

## Политика системы в отношении прав запроса ролей {#call-role}

#|
|| **Правило** | **Описание** ||
||Только для себя и своих подчиненных можно запрашивать роли | Правило ограничивает просмотр и запрос ролей, учитывая прямое подчинение по иерархии. Используется для критичных и закрытых систем.

Пример:

Пользователь IDM — руководитель группы. На странице системы, для которой установлено правило «Только для себя и своих подчиненных можно запрашивать роли», на вкладке **Роли** для этого пользователя будет отображаться: 
- Список активных ролей по сотрудникам, которые являются прямыми подчиненными этого пользователя.
- Пустой список, если в системе выданы роли только сотрудникам, которые не являются прямыми подчиненными этого пользователя.||
||Все могут запрашивать роли для всех | Все штатные сотрудники Яндекса могут запрашивать и просматривать роли любого сотрудника.||
|#

## Политика системы в отношении подтверждения ролей {#confirm-role}

#|
|| **Правило** | **Описание** ||
||Подтвержденная роль становится активной | IDM собирает подтверждения и самостоятельно переводит роль в состояние «Подтверждена». Затем высылает в систему только push-уведомления по логинам, которым необходимо активировать роль.

Пример:

1. Сотрудник запрашивает роль.
1. IDM собирает все подтверждения на выдачу этой роли.
1. Когда все подтверждения получены, роль переводится в состояние «Подтверждена».
1. IDM отправляет push-уведомление по логину в систему.
1. Система возвращает ответ:
    - При успешном выполнении запроса возвращается ответ cо статусом «ok» и кодом 0. Роль становится активной и переводится в состояние «Выдана».
    - Если ответ содержит другой код, а также статус «error» — роль не выдается и переводится в состояние «Ошибка».||
||Требуется подтверждение системы | IDM собирает подтверждения и высылает в систему push-уведомления по логинам, которым необходимо выдать роль. Система самостоятельно принимает решение о выдаче роли сотруднику.

Пример: 
1. Сотрудник запрашивает роль.
1. IDM собирает все подтверждения на выдачу этой роли.
1. IDM отправляет push-уведомления по каждому логину в систему, когда все подтверждения получены.
1. Система возвращает ответ «accepted» и соответствующее push-уведомление.
1. Роль переводится в состояние «Передана в систему».
1. Система обрабатывает запрос и возвращает ответ:
    - Если система подтверждает выдачу роли, возвращается ответ cо статусом «ok» и кодом 0. Роль становится активной и переводится в состояние «Выдана».
	
	{% cut "Пример ответа" %}
	
	`{"code": 0}`
	
	{% endcut %}
    
    
    - Если ответ содержит другой код, а также статус «error» — роль не выдается и переводится в состояние «Ошибка».
	
	{% cut "Пример ответа с ошибкой" %}
    
    `{"code": 43432, "error": "No connection to database"}`
	
    {% endcut %}
||
|#

Подробную информацию по взаимодействию систем см. в документе [HTTP API систем](https://wiki.yandex-team.ru/Intranet/idm/API/) (wiki).

## Политика системы в отношении редактирования дерева ролей через API {#change-tree-role}

#|
|| **Правило** | **Описание** ||
||Можно редактировать | Двусторонняя синхронизация дерева ролей: 
- IDM обращается к API системы (через [запрос `/info/`](idm-get-info.md)) и приводит дерево ролей в соответствие БД системы.
- Система инициирует обновление и отправляет push-уведомления в БД IDM при каждом изменении дерева ролей.

Также см. документ [Публичное API IDM (wiki)](https://wiki.yandex-team.ru/Intranet/idm/API/public/#redaktirovanie-putprefix/rolenodes/path/).||
||Нельзя редактировать | Односторонняя синхронизация дерева ролей:

- IDM обращается к API системы (через [запрос `/info/`](idm-get-info.md)) и приводит дерево ролей в соответствие БД системы.
- Система не отправляет push-уведомления в БД IDM при каждом изменении дерева ролей.

Также см. документ [Публичное API IDM (wiki)](https://wiki.yandex-team.ru/Intranet/idm/API/public/#redaktirovanie-putprefix/rolenodes/path/).||
|#

## Политика системы в отношении перезапроса ролей при смене сотрудником подразделения {#recall-role}

С помощью этой политики можно контролировать наличие ролей у сотрудников, сменивших структурное подразделение. При смене подразделения, как правило, меняются обязанности и полномочия сотрудника. Если роль не соответствует обязанностям, то ее необходимо перезапросить и отозвать.

#|
|| **Правило** | **Описание** ||
||Перезапрашивать роли при смене подразделения | Правило обязательно для SOX-систем.

Если сотрудник перешел в другое подразделение: 
1. IDM переводит роль в состояние «Нужно перезапросить».
1. IDM отправляет сотруднику уведомление о необходимости перезапроса роли.
1. Сотрудник перезапрашивает роль.
1. Подтверждающий в системе принимает решение: подтвердить или отклонить запрос.

Сотрудник может перезапросить роль в течение двух недель (в этот период роль сохраняет статус «Активная»). Роль отзывается, если ее не перезапросить или не подтвердить.||
||Не перезапрашивать роли при смене подразделения | Если сотрудник перешел в другое подразделение, IDM не переводит роль в состояние «Нужно перезапросить» и не отправляет сотруднику уведомление о необходимости перезапроса роли.||
|#

## Политика работы с неконсистентностями {#nonconsist}

{% include [entities-nonconsist](../_conref/conref/id-entities/nonconsist.md) %}

#|
|| **Правило** | **Описание** ||
||Не доверяем системе, требуем повторного подтверждения согласно workflow | Если в базе IDM присутствует роль, которая отсутствует в базе системы, роль удаляется из базы IDM.
Если в базе IDM отсутствует роль, которая существует в базе системы: 
1. IDM копирует роль в свою базу.
1. IDM применяет workflow системы. Роль переходит в состояние «Перезапрошена».
    Роль необходимо подтвердить в течение 14 дней.
    
    Неподтвержденные роли отзываются.

Подробную информацию см. в разделе [Разрешить неконсистентности](close-neconsist.md).||
||Доверяем системе, не требуем повторного подтверждения | Если в базе IDM присутствует роль, которая отсутствует в базе системы, роль удаляется из базы IDM.
Если в базе IDM отсутствует роль, которая существует в базе системы: 
1. IDM копирует роль в свою базу.
1. Применяет workflow системы. Роль получает статус «Активная».

Подробную информацию см. в разделе [Разрешить неконсистентности](close-neconsist.md).

{% note warning %}

Обязательно напишите обоснование, почему для вашей системы необходимо использовать это правило.

{% endnote %}

||
||Не доверяем системе, отзываем роль, запрашиваем заново | Правило обязательно для SOX-систем.

Если в базе IDM присутствует роль, которая отсутствует в базе системы, роль удаляется из базы IDM.

Если в базе IDM отсутствует роль, которая существует в базе системы: 
1. IDM копирует роль в свою базу.
1. IDM отправляет в систему push-уведомление на отзыв роли. Роль получает статус «Неактивная».
1. IDM запрашивает роль повторно, применяя workflow системы. Роль переходит в состояние «Запрошена».
1. Система решает, выдавать роль или не выдавать.

Подробную информацию см. в разделе [Разрешить неконсистентности](close-neconsist.md).||
|#

## Политика подтверждения своих правок в workflow {#workflow-change}

|Правило | Описание
|----- | -----
|Изменяющий воркфлоу может его подтверждать | Ответственный за систему или участник команды могут вносить изменения в workflow. Публиковать изменения в продакшн может только ответственный.
|Изменяющий воркфлоу не может его подтверждать | Ответственный за систему или участник команды могут вносить изменения в workflow. Подтвердить и опубликовать изменения в продакшн может второй ответственный в системе. Если второй ответственный отсутствует, подтвердить изменения может суперпользователь IDM.

## Ручка для сверки ролей {#hands}

«Ручка» — HTTP-запрос, с помощью которого система взаимодействует с серверами IDM.

#|
|| **Правило** | **Описание** ||
||Ручка get-roles | Синхронизация всех ролей пользователей между БД системы и БД IDM.
Используется для систем с большим количеством ролей. 
Подробнее см. раздел [Список пользователей и ролей (get-roles)](idm-get-roles.md).||
||Ручка get-all-roles | Синхронизация всех ролей пользователей между БД системы и БД IDM.
Используется для систем с небольшим количеством ролей. 
Подробнее см. раздел [Список пользователей и ролей (get-all-roles)](idm-get-all-roles.md).||
|#

## Поменять политику  {#change-politics}

Чтобы поменять политику, напишите на рассылку [tools@yandex-team.ru](tools@yandex-team.ru).

