# Дополнительные возможности

В workflow системы вы можете [добавить подтверждающих](add-confirmer.md) роли или [настроить уведомления](notifications.md) о событиях с ролью, а также использовать дополнительные возможности. Например, ограничить срок действия роли или автоматически выдавать роль сотруднику, если для него запрашивает роль непосредственный руководитель.

Чтобы использовать дополнительные возможности, выполните следующие действия:

1. Нажмите на ссылку с вашей системой на странице [**IDM. Все системы**](https://idm.yandex-team.ru/systems).
1. Перейдите на вкладку **Workflow**.
1. Нажмите кнопку **Редактировать**:

    {% cut "Ограничить срок действия роли" %}
    
    Чтобы роль выдавалась на определенный срок, в строке под нужной ролью введите `ttl_days = [количество_дней]`
	
    **Пример**
    
    Доступ будет предоставлен на семь дней. Через семь дней IDM автоматически отзовет доступ.
    ```
    if role['role'] ==  'manager':
    `ttl_days = 7`
    ```
    
	{% endcut %}
	
	{% cut "Добавить запрет на запрос роли" %}
	
    Чтобы запретить каким-либо сотрудникам запрашивать роли (например, внешним консультантам или сотрудникам определенного департамента), в строке под нужной ролью введите:
    ```
    **if** requester.works_in_dep('название_департамента_на_стаффе'):
    **raise** AccessDenied(u 'комментарий.')
    ```
    
    Если сотрудник, подходящий под прописанные условия, попытается запросить доступ, то IDM возвращает ошибку, содержащую текст из строки и комментарий.
    
    **Пример**
    
    Руководитель или сотрудник **Службы сопровождения биллинговой системы** (yandex_infra_int_support_bill) не сможет запросить роль.
    ```
    **if** requester.works_in_dep('yandex_infra_int_support_bil'):
    **raise** AccessDenied(u 'сотрудники из этого департамента не могут сами запрашивать доступы.')
    ```
    
    {% note info %}
    
    Правила для внешних консультантов:
    - Запрет на запрос роли действует только для сотрудников-консультантов из подразделения **Внешние консультанты**.
    - Если внешний консультант числится в общем подразделении **Яндекс** и одновременно является руководителем в подразделении **Внешние консультанты**, то он может запрашивать роли.
    
    {% endnote %}
	
	{% endcut %}
	
	{% cut "Автоматически добавлять сотрудника в AD группу" %}
    
    Чтобы при запросе роли сотрудник автоматически добавлялся в указанную группу в корпоративную службу [Active Directory (AD)](glossary.md#ad), в строке под нужной ролью введите `ad_groups = ['название_группы_1, название_группы_2']`
    Если роль будет отозвана у сотрудника, то IDM автоматически удалит сотрудника из AD группы.
    
    **Пример**
	
    ```
    **if** role == {'role':'4'}:
    ad_groups = [apex_group, biee_group]
    ```
    
	{% endcut %}
	
	{% cut "Отправлять запрашивающему копию уведомления о получении доступа" %}
	
    Чтобы IDM присылал копию уведомления о получении доступа не только сотруднику, получившему роль, но и самому запрашивающему, в строке под нужной ролью введите `email_cc = requester.email`
    См. также раздел [Включить уведомления о событиях с ролью](notifications.md).
    
    **Пример**
    
    Если запрашивается роль manager, отправлять копию уведомления руководителю сотрудника, для которого запрашивается роль, а также самому запрашивающему.
    ```
    **if** role['role'] ==  'manager':
    approvers = []
    boss = user.get_boss()
    **if** boss **is not None**:
    email_cc = boss.email
    email_cc = requester.mail
    ```
    
	{% endcut %}
	
	{% cut "Отправлять руководителю копию уведомления о получении доступа" %}
	
    Чтобы IDM присылал копию уведомления о получении доступа руководителю сотрудника, получившему роль, в строке под нужной ролью выполните следующее:
    - Если копию уведомления должен получить непосредственный руководитель сотрудника, введите:
    ```
    boss = user.get_boss()
    **if** boss **is not None**:
    email_cc = boss.email
    ```
    
    - Если копию уведомления должен получить непосредственный руководитель сотрудника или его заместитель, введите:
    ```
    boss = user.get_boss_or_zam()
    **if** boss_or_zam **is not None**:
    email_cc = boss.email
    ```
    
    {% note info %}
    
    Если руководитель или заместитель отсутствует, запрос на роль отклоняется.
    См. также раздел [Включить уведомления о любых событиях с ролью](notifications.md).
    
    {% endnote %}
	
	{% endcut %}
	
	{% cut "Запрашивать связанные роли при выдаче текущей роли" %}
    
    Чтобы IDM автоматически запрашивал связанные роли при выдаче текущей, в строке под нужной ролью введите:
    ```
    ref_roles = [{
    'system': 'название_системы',
    'role_data': {'role': 'название_связанной_роли'},
    }]
    ```
    
    **Пример**
    
    Если пользователь получил роль «group-21», выдать также роль «group-22» в системе «testsystem».
    ```
    if role.get('role') == 'group-21':
    ref_roles = [{
    'system': 'testsystem',
    'role_data': {'role': 'group-22'},
    }]
    ```
    
	{% endcut %}
	
	{% cut "Показывать предупреждение при запросе роли" %}
    
    - Если требуется выводить уведомление на русском языке, в строке под нужной ролью введите `warning = 'текст_предупреждения'`
    - Если требуется уведомление на русском и английском языке, в строке под нужной ролью введите `warning = {'ru': 'текст_предупреждения_на_русском', 'en': 'warning_in_english'}`
    - Если требуется уведомление на русском и английском языке, а также есть текст, не требующий перевода, в строке под нужной ролью введите `warnings = {'Текст_предупреждения, не_требующий_перевода', {'ru': 'текст_предупреждения_на_русском', 'en': 'warning_in_english'}}`
    Язык предупреждения определяется ключом 'ru' или 'en', и зависит от языка, выбранного в настройках пользователя.
    
    **Пример**
	
    Если пользователь запрашивает роль manager, показывать уведомление "Вы запрашиваете роль".
    ```
    if role['role'] ==  'manager':
    warning = 'Вы запрашиваете роль'
    ```
    {% endcut %}
	
	{% cut "Автоматически предоставлять доступ руководителям указанных подразделений" %}
	
    Чтобы IDM автоматически выдавал руководителям указанных подразделений запрашиваемую роль, в строке под нужной ролью введите:
    ```
    **if** user in all_heads_of('название_подразделения_на_стаффе'):
    approvers = []
    ```
    
    **Пример**
    
    Если сотрудник, для которого запрашивается роль manager, является руководителем **Отдела сопровождения внутренних процессов** (yandex_infra_int_support), доступ предоставляется автоматически. В противном случае требуется подтверждение от oficerovd, а также от руководителя **Отдела биллинговой системы** (или от его заместителя) (yandex_infra_int_automation_billing).
    ```
    **if** role['role'] ==  'manager':
    **if** user **in** all_heads_of('yandex_infra_int_support'):
    approvers = []
    **else:**
    approvers = ['oficerovd', get_head_of_or_zam('yandex_infra_int_automation_billing')]
    ```
    {% endcut %}
	
	{% cut "Проверять, является ли сотрудник руководителем подразделения" %}
	
    Чтобы IDM автоматически выдавал роль, если запрашивающий является руководителем указанного подразделения, в строке под нужной ролью введите:
    ```
    if requester.is_head_of('название_подразделения_на_стаффе'):
    approvers = []
    ```
    
    Если запрашивающий является руководителем **Дивизиона отчетности, планирования и контроля** (yandex_fin_control) или пользователь, для которого запрашивается роль работает в этом дивизионе, то доступ выдается без подтверждения. В противном случае подтверждение требуется от руководителя сотрудника, а также от руководителя **Финансового департамента** (или его заместителя).
    ```
    **if** requester.is_head_of('yandex_fin_control') or user.works_in_dep('yandex_fin_control'):
    approvers = []** else:**
    approvers = [approver(boss_of(user)), get_head_of_or_zam('yandex_fin')]
    ```
    {% endcut %}
	
	{% cut "Проверять, работает ли сотрудник в указанном подразделении" %}
	
    
    Чтобы IDM автоматически выдавал роль сотруднику, работающему в указанном подразделении, в строке под нужной ролью введите:
    ```
    if user.works_in_dep('название_подразделения_на_стаффе'):
    approvers = []
    ```
    
    **Пример**
    
    Если запрашивающий является руководителем **Дивизиона отчетности, планирования и контроля** (yandex_fin_control) или сотрудник работает в этом дивизионе, то доступ выдается без подтверждения. В противном случае подтверждение требуется от руководителя сотрудника.
    ```
    **if** role['role'] ==  'manager':
    **if **requester.is_head_of('yandex_fin_control') or user.works_in_dep('yandex_fin_control'):
    approvers = []
    **else:**
    approvers = [approver(boss_of(user))]
    ```
    
	{% endcut %}
	
	{% cut "Проверять, является ли один сотрудник руководителем другого" %}
	
    Чтобы IDM автоматически выдавал роль сотруднику, если для него запрашивает роль непосредственный руководитель, в строке под нужной ролью введите:
    ```
    if requester.is_boss_of(user):
    approvers = []
    ```
    
    **Пример**
    
    Если запрашивающий является руководителем сотрудника, для которого запрашивается роль, то подтверждение не требуется. В противном случае подтверждение требуется от руководителя сотрудника и руководителя **Отдела биллинговой системы** (yandex_infra_int_automation_billing).
    ```
    **if** requester.is_boss_of(user):
    approvers = []
    **else:**
    approvers = [approver(boss_of(user)), get_head_of('yandex_infra_int_automation_billing')]
    ```
    
	{% endcut %}
	
	{% cut "Проверять, есть ли у сотрудника какая-либо роль" %}
    
    Чтобы IDM не требовал подтверждения нового доступа, если сотруднику была ранее выдана указанная роль в системе, в строке под нужной ролью введите:
    ```
    **if** user.has_role({'данные_роли'}):
    approvers = []
    ```
    
    {% note info %}
    
    Для проверки роли в другой системе можно использовать параметр `systemify`. Чтобы использовать этот параметр, обратитесь за консультацией к команде IDM: [tools@yandex-team.ru](mailto:tools@yandex-team.ru).
    
    {% endnote %}
	
	{% endcut %}
    
1. Введите комментарий.
1. Нажмите кнопку **Применить изменения**.

Полное описание всех переменных и функций wokflow представлено в разделе [Справочник workflow](workflow-list.md).

