# Приложение 3. Справочник workflow

## Переменные workflow {#workflow}

В workflow определены следующие переменные:

#|
||Название переменной | Тип данных | Описание | Значение по умолчанию||
||`Access_denied` | Объект | Добавляет запрет на запрос роли. | —||
||`approvers` | Массив | Список пользователей, подтверждающих роли. | —||
||`ad_groups` | Массив | Список групп в службе Active Directory, в которые будет добавлен пользователь при выдаче роли. | —||
||`email_cc` | Массив | Список адресов электронной почты, на которые нужно отправлять уведомления о событиях с ролью. Возможно использование вместе с функцией `recepient`. | —||
||`fields_data` | Массив | Данные, заполненные при запросе роли с помощью определенных в [дереве ролей](https://doc.yandex-team.ru/idm/idm-guide/entities/role-tree.html) полей. | —||
||`group` | Объект | Группа, для которой запрашивается роль. | —||
||`no_email` | Логическое | Уведомление о событиях с ролью для всех, кроме запросившего. | `False`||
||`node` | Объект | [Узел](https://doc.yandex-team.ru/idm/idm-guide/entities/tree-knots.html) в дереве ролей. | —||
||`notify_everyone` | Логическое | Уведомление о событиях с ролью для всех подтверждающих. | `None`||
||`ref_roles` | Массив | Список связанных ролей, которые будут запрошены при выдаче текущей роли. | —||
||`requester` | Объект | Пользователь, запрашивающий роль. | —||
||`review_days` | Число | Срок пересмотра роли в сутках. | —||
||`role` | Массив | Описание [роли](https://doc.yandex-team.ru/idm/idm-guide/entities/user-role.html). | —||
||`send_sms` | Логическое | SMS-уведомление при выдаче роли. | `False`||
||`scope` | Строка | Путь по ключам дерева ролей до родительского узла относительно текущего. | —||
||`system` | Объект | Свойства [системы](https://doc.yandex-team.ru/idm/idm-guide/entities/system.html), к которой относится workflow. | —||
||`user` | Объект | Пользователь, для которого запрашивается роль. | —||
||`ttl_days` | Число | Срок действия роли в сутках. | —||
||`warnings` | Строка или Массив | Список предупреждений, которые необходимо вывести при запросе роли.
Если необходимо одно предупреждение, возможно использование строковой переменной `warning` (без `s`).

При использовании переменной `warnings` в виде словаря (массива) обязательно использование ключей `ru` и `en`. Значениями словарей будут являться строки с текстом предупреждений. | —||
|#


## Функции workflow {#function}

#|
||Название функции  | Описание||
||`any_from` | Получает список подтверждающих, в котором подтверждение роли требуется от любого. Использует аргументы: 
- `notify` — необходимость уведомления подтверждающих (возможные значения `False`, `True`, по умолчанию `None`);
- `priority` — число, определяющее приоритет подтверждающего (по умолчанию `DEFAULT_PRIORITY`).

Подтверждающих должно быть двое и более (при этом подтвердить может любой из них)||
||`groupify` | Получает группу по идентификатору на Стаффе.||
||`recipient` | Собирает элементы для списка в переменной `email_cc`. Использует аргументы: 
- `email` — строка с адресом электронной почты получателя оповещений;
- `lang` — язык оповещений (возможные значения: `'ru'`, `'en'`);
- `requested` — наступило событие «роль запрошена» (возможные значения `False`, `True`);
- `granted` — наступило событие «роль выдана» (возможные значения `False`, `True`);
- `deprived` — наступило событие «роль отозвана» (возможные значения `False`, `True`);
- `declined` — наступило событие «роль отклонена» (возможные значения `False`, `True`);
- `reminders` — напоминание о необходимости подтверждения роли. Уведомления отправляются раз в сутки в 9 утра до тех пор, пока роль не будет подтверждена или отклонена (возможные значения `False`, `True`).||
||`systemify` | Проверяет роли в другой системе. Чтобы использовать этот параметр, обратитесь за консультацией к команде IDM: [tools@yandex-team.ru](tools@yandex-team.ru)||
|#

## Методы workflow {#methods}

#|
||Название метода  | Объект | Описание||
||`all_heads_of` | `system` | Возвращает список руководителей указанного отдела и всех его подотделов.||
||`all_roles` | `user`
`requester` | Возвращает список ролей, выданных пользователю в этой системе, если у пользователя уже есть выданная роль с переданными данными.||
||`all_users_with_role(<данные_роли>)` | `system` | Возвращает список всех пользователей, которым выдана роль.||
||`get_ancestors()` | `node` | Возвращает список всех предков узла.||
||`get_ancestor(level)` | `node` | Возвращает предка узла с уровнем `level`. Отрицательный `level` означает расстояние от узла, а не от корня.||
||`get_aliases(type=None)` | `node` | Возвращает список синонимов узла. Если указано значение `type`, то возвращает только синонимы данного типа.||
||`get_boss` | `user`

`requester` | Возвращает ближайшего руководителя, у которого на стаффе нет отметки об отсутствии (командировка, болезнь, обучение, отпуск). Как правило, функция используется, если подтверждение роли нужно не от руководителя сотрудника, а от руководителя сервиса / системы / другого подразделения. 

{% cut "Пример" %}

Сотрудник «Отдела документирования» запрашивает роль «Кладовщик Закупки» в системе OeBS. Подтверждать роль должен только руководитель «Службы сопровождения сделок». Руководитель «Отдела документирования» не принимает участие в подтверждении роли.

{% endcut %}


{% note info %}

Если непосредственный руководитель на больничном, но при этом работает, функция считает его недоступным. При этом руководитель не увидит эту роль в списке запросов (то есть не сможет подтвердить ее). 
Администраторы IDM рекомендуют использовать функцию `get_boss_or_zam`.

{% endnote %}


||
||`get_boss_or_zam` | `user`

`requester` | Возвращает ближайшего вышестоящего руководителя или его заместителя, у которого на стаффе нет отметки об отсутствии (командировка, болезнь, обучение, отпуск).||
||`get_head_of` | `user`

`requester` | Возвращает ближайшего руководителя подразделения, у которого на стаффе нет отметки об отсутствии (командировка, болезнь, обучение, отпуск).

{% note info %}

Если непосредственный руководитель на больничном, но при этом работает, функция считает его недоступным. При этом руководитель не увидит эту роль в списке запросов (то есть не сможет подтвердить ее). 

Администраторы IDM рекомендуют использовать функцию `get_head_of_or_zam`.

{% endnote %}||

||`get_head_of_or_zam` | `user`

`requester` | Возвращает непосредственного руководителя подразделения, у которого на стаффе нет отметки об отсутствии (командировка, болезнь, обучение, отпуск). Иначе возвращает одного из заместителей руководителя подразделения, который присутствует на работе.||
||`get_responsibilities()` | `node` | Возвращает список ответственных узла.||
||`get_owners` | `node` | Возвращает владельцев активных ролей, которые выданы на узел со слагом `owning_slug`, являющийся сестринским для текущего. Использует аргументы: 
- `look_up` — повторный поиск владельцев родительского узла, если владельцы не были найдены. Возможные значения `False`, `True`. При значении `True` поиск продолжается до тех пор, пока владельцы не будут найдены.
- `collect` — повторный поиск владельцев текущего узла и всех предков, если владельцы / предки не были найдены. Возможные значения `False`, `True`. При значении `True` владельцы не будут повторяться и будут отсортированы в порядке уменьшения уровня узла (сначала владельцы текущего узла, затем родительского узла и так далее).
- `groups` — Возможные значения `False`, `True`.
- `include_self` — список владельцев родительских и сестринских узлов. Используется с аргументом `look_up` или `collect`. Возможные значения `False`, `True`. При значении `False` владельцы сестринских узлов пропускаются.||
||`has_role` | `user`

`requester` | Проверяет, есть ли у пользователя роль в системе.||
||`is_boss_of` | `user`

`requester` | Проверяет, является ли один сотрудник руководителем другого.
Используется с||
||`is_head_of` | `user`

`requester` | Проверяет, является ли человек руководителем любого из указанных подразделений.||
||`works_in_dep` | `user`

`requester` | Проверяет, работает ли сотрудник в одном из указанных структурных подразделений. Название подразделения можно взять из URL на Стаффе или использовать автозаполнение. Автозаполнение срабатывает после ввода `.works_in_dep('`||
|#

## Примеры {#examples}

- Подтверждающим роли «terminator» должен быть любой сотрудник из списка admins. Список admins содержит владельцев узла и всех предков. В системе о владении узлом говорит роль «grant».
    ```
    if role == {'terminator'}:
    admins = node.get_owners('grant', collect=True)
    approver = [any_from(admins)]
    ```
    
- Подтверждающим должен быть любой пользователь, у которого в системе есть роль «TMS_ADMIN»
    ```
    approvers = [any_from(system.all_users_with_role({'interface': 'mbi', 'role': 'TMS_ADMIN'}))]
    ```
    
- Всем подтверждающим из списка «grants» будут отправляться уведомления о действиях с ролью «terminator». Список grants содержит владельцев узла, о владении узлом говорит роль «grant».
    
    ```
    if role == {'terminator'}:
    grants = node.get_owners('grant')
    approvers = [any_from([grants])]
    notify_everyone=True
    ```

