# Все вопросы и ответы

#|
||**Роли**

[Не могу перезапросить роль](#cant-recall)

[Не могу понять, кто ответственный за выдачу роли](#who-is-main-confirmer)

[Роль активна, однако доступ к системе отсутствует](#access-denied)

[Сотрудник покинул группу, однако роль все еще активна](#user-left-group)

[Не могу отозвать роль](#cant-delete-role)

[При запросе роли не могу использовать свой логин](#cant-use-login)

[Не могу найти ранее выданную роль](#cant-find-role)

[Кнопка «Перезапросить» неактивна](#inactive-button)

[Сообщение «Некоторые роли требуют повторного подтверждения»](#role-error)

[Не могу запросить роль на группу](#group-role)

[Не могу понять, какие роли у группы отзовутся после организационных изменений](#org-changes) | **Пароли**

[Не могу найти в письме пароль от базы Oracle](#cant-find-oracle-pswd)

[Не могу найти пароль для нового логина](#cant-find-new-login-pswd)

[Сообщение «Пароль к базе Oracle устарел»](#old-oracle-pswd)||
||**Ошибки**

[Не могу понять, что означает ошибка](#unknown-error)

[Ошибка «login <паспортный_логин> already have role: <название_роли>»](#login-already-have-role)

[Ошибка «Role with such system_specific already exists»](#role-already-exists)

[Ошибка «Не удалось добавить роль в систему»](#cant-add-role) ||
|#

## Проблемы с ролями {#roles}

### Не могу перезапросить роль {#reorder-role}

Если при попытке выполнить действие с [ролью](https://doc.yandex-team.ru/idm/idm-guide/entities/user-role.md) (например, перезапросить роль) вы получаете сообщение «Для этой роли вы не можете выполнить действие», напишите на рассылку <tools@yandex-team.ru>.

Ошибка может возникнуть, если в [workflow](https://doc.yandex-team.ru/idm/idm-guide/entities/workflow.md) для пользователя прописан запрет на запрос доступов (например, если сотрудник является внешним консультантом). Обратитесь к владельцу системы.

### Не могу понять, кто ответственный за выдачу роли {#responsible}

Список ответственных перечислен в окне **Запрашиваемая роль**, а также в письме-уведомлении на подтверждение роли.

### Роль активна, однако доступ к системе отсутствует {#section_am2_5s2_scb}

Если вы получили подтверждение о выдаче роли, однако доступ к системе все равно отсутствует:

1. [Откройте](https://idm.yandex-team.ru/) страницу IDM.
1. Найдите нужную роль и нажмите на ее название.
    В правой части экрана откроется карточка роли.
    
1. Проверьте статус в поле **Состояние**:
    #### Выдана
    Если роль находится в состоянии **Выдана**, решить проблему может только ответственный за систему. Список ответственных перечислен на странице системы. Напишите письмо ответственному. В письме подробно опишите проблему, приложите скриншот карточки роли и вставьте ссылку на роль.
    Чтобы скопировать ссылку:
    1. Нажмите кнопку ![](../image/copy-link.png) в карточке роли.
    1. Нажмите на клавиатуре сочетание клавиш **Ctrl + C**.
    ![](../image/copy-link-2.png)
    
    #### Запрошена, Отозвана, Отклонена, Ошибка
    Если роль находится в состоянии **Запрошена**, **Отозвана**, **Отклонена** или **Ошибка**, [перезапросите роль](query-role.md). Если проблему решить не удалось, напишите на рассылку [tools@yandex-team.ru](tools@yandex-team.ru). В письме подробно опишите проблему и вставьте ссылку на роль.
    {% include [roles-copy-link](../_conref/conref-faq/id-roles/copy-link.md) %}

### Не могу отозвать роль {#close-role}

Если при попытке отозвать роль вы получаете сообщение «Для этой роли вы не можете выполнить действие», скорее всего, вы пытаетесь отозвать одну из следующих ролей:

- Персональную групповую роль.
    Чтобы отозвать групповую роль, необходимо покинуть группу. По истечении семи дней роль автоматически отзовется.
    
- Связанную роль.
    Чтобы отозвать связанную роль, необходимо отозвать основную роль.
    
- Удаленную роль (или систему).
    Чтобы узнать, есть ли аналогичная роль, обратитесь к владельцу системы.
    

### При запросе роли не могу использовать свой логин {#incorrect-login}

В IDM принят стандартный формат логина: «префикс yndx»+«доменный_логин» + «название_роли [опционально]». Такой паспортный логин можно сформировать вручную (при регистрации в [Яндекс.Паспорте](http://passport.yandex.ru/) из внутренней сети Яндекса) или автоматически (при получении роли через IDM).

При запросе роли можно использовать только те логины, которые предлагает IDM (все возможные варианты представлены в списке [Паспортный логин](https://doc.yandex-team.ru/idm/idm-guide/entities/passport-login.md)). Если информации о паспортном логине сотрудника в IDM нет, автоматически создается новая учетная запись в Яндекс.Паспорте. Пароль от этой учетной записи отправляется на почту сотрудника.

### Не могу найти ранее выданную роль {#not-found}

Скорее всего, роль была отозвана. Отозванные роли можно [перезапросить](query-role.md#recall-role).

### Кнопка «Перезапросить» неактивна {#recall}

[Склонируйте](query-role.md#clone-role) нужные роли.

### Сообщение «Некоторые роли требуют повторного подтверждения» {#letter}

При изменениях в организационной структуре на Стаффе вы получите письмо с темой «Некоторые роли требуют повторного подтверждения».

В течение 14 дней необходимо [перезапросить роли](query-role.md#recall-role), в противном случае все перечисленные в письме роли будут отозваны.

### Не могу запросить роль на группу  {#group-role}

Существует несколько причин, по которым в системе отсутствует возможность запрашивать роли на группу: 
- В системе установлена политика «Только для себя и своих подчиненных можно запрашивать роли».
    Если вы не являетесь руководителем группы, для которой запрашиваете роль, обратитесь к ответственному [системы](https://idm.yandex-team.ru/systems). Список ответственных перечислен на странице системы.
    
- Система не поддерживает групповые роли.
    Напишите запрос на рассылку системы. Адрес рассылки указан на странице системы.

### Сотрудник покинул группу, однако роль все еще активна {#left-group}

Роль выдается на группу, в которой состоит пользователь. Все участники группы получают связанную персональную роль. Если пользователь покидает группу, роль автоматически отзывается по истечении семи дней.

### Не могу понять, какие роли у группы отзовутся после организационных изменений {#group-roles}

Напишите на рассылку <tools@yandex-team.ru>.


## Проблемы с паролями {#passwords}

### Не могу найти в письме пароль от базы Oracle {#oracle-pswd}

Пароль от базы ORACLE совпадает с вашим доменным логином в нижнем регистре. Однако при первом входе в базу Oracle необходимо изменить пароль.

### Не могу найти пароль для нового логина {#new-login}

Если [при запросе роли](query-role.md#add-role) вы выбрали из списка новый паспортный логин, Яндекс.Паспорт отправит письмо на вашу электронную почту со ссылкой для установки нового пароля.

Установка нового пароля необходима для завершения регистрации логина. Ссылка действительна в течение одной недели.
Если логин не зарегистрировать, после подтверждения роли возникнет ошибка «Не удалось добавить роль в систему». Подробнее см. раздел [Ошибки](#errors). 
### Что делать, если пароль к базе Oracle устарел {#pswd-letter}

При первом входе в базу Oracle необходимо изменить пароль.

Новый пароль должен отвечать следующим требованиям: 
- длина не менее восьми символов;
- содержит как прописные, так и строчные латинские буквы;
- содержит цифры и знаки пунктуации;
- не входит в список популярных паролей (например, к популярным паролям относятся «qwerty», «123456»);
- не совпадает и не похож на логин или название базы данных.


## Ошибки {#errors}

### Не могу понять, что означает ошибка {#unknown-error}

Ошибки при запросе роли в большинстве случаев исходят от самой системы, а не от IDM. Названия ошибок самостоятельно задают ответственные за [систему](https://doc.yandex-team.ru/idm/idm-guide/entities/system.md).

Чтобы расшифровать ошибку, обратите внимание на ее текст:

- Если текст содержит выражение «PluginFatalError», обратитесь к владельцу системы. Список систем, подключенных к IDM, представлен на странице [IDM. Все системы](https://idm.yandex-team.ru/systems).
- Если текст содержит только код ошибки, напишите письмо на рассылку [tools@yandex-team.ru](tools@yandex-team.ru).

### Ошибка «login <паспортный_логин> already have role: <название_роли>» {#already-have-role}

Ошибка может возникнуть в следующих случаях:

- Если вы пытаетесь запросить в Директе вторую роль на тот же паспортный логин.
    Например, ошибка: "login yuliya-k already have role: manager" означает, что у сотрудника уже есть роль Менеджер, привязанная к логину yuliya-k.
    
    Чтобы решить проблему, запросите роль заново на другой логин.
    
- Если в Директе на ваш паспортный логин все еще записана ранее отозванная роль.
    Чтобы решить проблему, напишите запрос на удаление отозванной роли в службу поддержки Директа: [direct@yandex-team.ru](mailto:direct@yandex-team.ru).
    

### Ошибка «Role with such system_specific already exists» {#already-exists}

Ошибка может возникнуть, если вы пытаетесь запросить в Маркете вторую роль на тот же паспортный логин.

Чтобы решить проблему, запросите роль заново на другой логин.

### Ошибка «Не удалось добавить роль в систему» {#cant-add-role}

В некоторых системах при запросе роли необходимо создать новый логин. После отправки запроса на вашу электронную почту придет письмо со ссылкой для установки нового пароля. Установка нового пароля необходима для завершения регистрации логина. Ссылка действительна в течение одной недели.

Если логин не зарегистрировать, после подтверждения роли возникнет ошибка «Не удалось добавить роль в систему». 
![](../image/role-error.png)

Чтобы решить проблему: 
1. Найдите письмо от **Яндекс.Паспорт**.
1. Перейдите по ссылке из письма.
1. Завершите регистрацию логина, если срок действия ссылки не истек. В противном случае напишите на рассылку [sp-passport@yandex-team.ru](mailto:sp-passport@yandex-team.ru).
    После регистрации логина заново запросите на него роль.

