const { formats } = require('@yandex-int/palmsync')

function assertWarn(expr, message) {
    if (!expr) {
        console.warn(message)
    }
}

/* eslint-disable camelcase */
const {
    palmsync_testpalmToken,
    palmsync_s3MdsAccessKeyId,
    palmsync_s3MdsAccessSecretKey,
} = process.env
/* eslint-enable camelcase */

assertWarn(
    palmsync_testpalmToken,
    'Define palmsync_testpalmToken env variable: https://testpalm.yandex-team.ru/internal/profile',
)
assertWarn(
    palmsync_s3MdsAccessKeyId,
    'Define palmsync_s3MdsAccessKeyId env variable: https://wiki.yandex-team.ru/mds/s3-api/authorization/',
)
assertWarn(
    palmsync_s3MdsAccessSecretKey,
    'Define palmsync_s3MdsAccessSecretKey env variable: https://wiki.yandex-team.ru/mds/s3-api/authorization/',
)

module.exports = {
    project: 'idm_backend_palmsync',
    s3MdsUpload: true,
    s3MdsBucketName: 'crowdtest',
    filePatterns: {
        yaml: /\.yaml$/,
    },
    sets: {
        yaml: {
            desktop: {
                specs: ['idm/tests/**/*.testpalm.yml'],
                baseUrl: '/',
                browsers: ['yandex-browser-desktop'],
            },
        },
    },
    schemeExtension: [
        {
            name: 'priority',
            required: true,
            meta: true,
            format: formats.isEnum('blocker', 'critical', 'normal', 'minor', 'trivial'),
        },
    ],
}

// Дефолтное значение из cli опций перетирает опцию из конфига
process.env.palmsync_s3MdsUpload = module.exports.s3MdsUpload
