from tastypie.authentication import Authentication

from django.views.generic import View
from django.http import HttpResponse

from idm.utils import json


class RequiredAuthentication(Authentication):
    def is_authenticated(self, request, **kwargs):
        return request.user.is_authenticated


class NotFoundView(View):
    def dispatch(self, request, *args, **kwargs):
        answer = json.dumps({
            'message': 'resource not found',
            'error_code': 'NOT_FOUND',
        })
        response = HttpResponse(
            content=answer,
            content_type='application/json; charset=utf-8',
            status=404,
        )
        return response
