# coding: utf-8


from tastypie.api import Api

from idm.api.frontend import (
    action, all_approvers, approverequest,
    favoritesystem, group, inconsistency, membership, role, rolenode,
    rolerequest, rolerequestfields,
    user, system, transfer, workflow, changed_roles_for_new_parent,
    rolerequestadditionalfields,
)
from idm.api.frontend.batch import resource as batch
from idm.api.frontend.permissions import all as permissions_all, rolerequest as permissions_rolerequest
from idm.api.frontend.suggest import (
    group as suggest_group,
    internalrole as suggest_internalrole,
    raw as suggest_raw,
    rolenode as suggest_rolenode,
    rolenodeset as suggest_rolenodeset,
    service as suggest_service,
    subject as suggest_subject,
    system as suggest_system,
    user as suggest_user,
    tvm as suggest_tvm,
)
from idm.api.frontend.suggest.fields import (
    conductor as suggest_conductor,
    macro as suggest_macro,
    metrika_counter as suggest_metrika_counter,
    app_metrica as suggest_app_metrica,
)

api = Api(api_name='frontend')

api.register(action.ActionResource())
api.register(all_approvers.AllApproversResource())
api.register(approverequest.ApproveRequestResource())
api.register(batch.BatchResource(api=api))
api.register(favoritesystem.FavoriteSystemResource())
api.register(group.GroupResource())
api.register(inconsistency.InconsistencyResource())
api.register(membership.MembershipResource())
api.register(permissions_all.PermissionsResource())
api.register(permissions_rolerequest.RoleRequestPermissionsResource())
api.register(role.FrontendRoleResource())
api.register(rolenode.RoleNodeResource())
api.register(rolerequest.RoleRequestResource())
api.register(rolerequestfields.RoleRequestFieldsResource())
api.register(rolerequestadditionalfields.RoleRequestAdditionalFieldsResource())
api.register(suggest_group.GroupSuggestSwitchResource())
api.register(suggest_internalrole.AllInternalRoleSuggestResource())
api.register(suggest_raw.ActionTypeSuggestResource())
api.register(suggest_raw.AuthFactorSuggestResource())
api.register(suggest_raw.GroupTypeSuggestResource())
api.register(suggest_raw.HandleSuggestResource())
api.register(suggest_raw.InconsistencyStateSuggestResource())
api.register(suggest_raw.InconsistencyTypeSuggestResource())
api.register(suggest_raw.LibrarySuggestResource())
api.register(suggest_raw.RoleStateSuggestResource())
api.register(suggest_service.ServiceSuggestResource())
api.register(suggest_tvm.TvmSuggestResource())
api.register(suggest_conductor.ConductorGroupSuggestResource())
api.register(suggest_macro.MacroSuggestResource())
api.register(suggest_app_metrica.AppMetricaSuggestResource())
api.register(suggest_metrika_counter.MetrikaCounterSuggestResource())
api.register(suggest_rolenode.RoleNodeSuggestSwitchResource())
api.register(suggest_rolenodeset.AllNodeSetSuggestResource())
api.register(suggest_subject.SubjectSuggestSwitchResource())
api.register(suggest_system.AllSystemsSuggestResource())
api.register(suggest_user.UserSuggestSwitchResource())
api.register(system.SystemResource())
api.register(transfer.TransferResource())
api.register(user.UserResource())
api.register(workflow.WorkflowResource())
api.register(changed_roles_for_new_parent.GroupChangedRolesResource())
