# coding: utf-8


from idm.api.frontend.base import FrontendApiResource
from idm.core.models import Approve
from tastypie import fields


class ApproveResource(FrontendApiResource):
    requests = fields.ToManyField(
        'idm.api.frontend.approverequest.ApproveRequestNoRecursionResource',
        'requests', full=True)
    status = fields.CharField(attribute='state')

    class Meta(FrontendApiResource.Meta):
        abstract = False
        queryset = Approve.objects.order_by('id')
        object_class = Approve
        resource_name = 'approves'
        list_allowed_methods = ['get']
        detail_allowed_methods = ['get']
        fields = ['requests', 'status']
