# coding: utf-8


import json


class ApiRequest(object):
    id = method = path = body = None

    def __init__(self, form):
        self._form = form

        if form.is_valid():
            self.id = self._form.cleaned_data.get('id')
            self.method = self._form.cleaned_data['method']
            self.path = self._form.cleaned_data['path']

            # Вот тут удаляется первый слеш из path, поэтому если он начинается не со слеша, то удаляется полезный слеш
            # https://github.com/django/django/blob/stable/2.2.x/django/core/handlers/wsgi.py#L78
            if not self.path.startswith('/'):
                self.path = '/' + self.path

            self.body = self._form.cleaned_data['body']
        else:
            self.id = self._form.data.get('id')

    def is_valid(self):
        return self._form.is_valid()

    @property
    def error_message(self):
        if not self._form.is_valid():
            return self._form.get_error_message()

    @property
    def encoded_body(self):
        data = self.body

        if isinstance(data, (list, dict)):
            data = json.dumps(data, ensure_ascii=False)
        elif data is None:
            data = ''

        if isinstance(data, str):
            data = data.encode('utf-8')

        return data

    def as_dict(self):
        return {
            'method': self.method,
            'path': self.path,
            'body': self.body,
        }
