# coding: utf-8


from django.conf import settings, UserSettingsHolder


class override_settings(object):
    """
    Simplified copy of `override_settings` from django.test.utils
    """

    def __init__(self, **kwargs):
        self.options = kwargs

    def __enter__(self):
        self.enable()

    def __exit__(self, exc_type, exc_value, traceback):
        self.disable()

    def enable(self):
        override = UserSettingsHolder(settings._wrapped)
        for key, new_value in self.options.items():
            setattr(override, key, new_value)
        self.wrapped = settings._wrapped
        settings._wrapped = override

    def disable(self):
        settings._wrapped = self.wrapped
        del self.wrapped
