# coding: utf-8


from idm.api.frontend import apifields
from idm.api.frontend.base import FrontendApiResource
from idm.users.models import GroupResponsibility


class GroupResponsibilityResource(FrontendApiResource):
    """
    Ресурс ответственных за группы
    """
    group = apifields.GroupForeignKey()
    user = apifields.UserForeignKey()

    class Meta(FrontendApiResource.Meta):
        abstract = False
        object_class = GroupResponsibility
        queryset = GroupResponsibility.objects.all()
        resource_name = 'groupresponsibilities'
        allowed_methods = ['get']
        limit = 100
