# coding: utf-8


from contextlib import contextmanager

from django.utils.encoding import force_text
from django.utils.translation import ugettext as _

from idm.api.exceptions import Conflict
from idm.core.workflow import exceptions
from idm.core.exceptions import MultiplePassportLoginUsersError
from idm.users.models import User


@contextmanager
def convert_role_request_exceptions(**extra):
    try:
        yield
    except User.DoesNotExist:
        error_message = {'error': _('Не найден сотрудник, который должен подтвердить выдачу роли.')}
    except exceptions.NoBossError as exception:
        error_message = force_text(exception)
    except exceptions.DataValidationError as exception:
        error_message = exception.message
        extra.setdefault('errors', {})
        extra['errors'].update({
            'fields_data': exception.errors
        })
    except exceptions.AccessDenied as exception:
        error_message = force_text(exception)
        if not error_message:
            error_message = _('Запрос роли запрещён согласно правилам workflow')
    except (
            exceptions.WorkflowError,
            exceptions.BrokenSystemError,
            exceptions.RoleRequestError,
            MultiplePassportLoginUsersError,
    ) as exception:
        error_message = force_text(exception)
    else:
        return

    raise Conflict(message=error_message, **extra)
