# coding: utf-8


from idm.api.frontend import apifields
from idm.api.frontend.base import FrontendApiResource
from idm.core.models import RoleAlias


class RoleAliasResource(FrontendApiResource):
    """
    Ресурс алиаса узла дерева ролей
    """
    node = apifields.RoleNodeForeignKey()

    class Meta(FrontendApiResource.Meta):
        abstract = False
        object_class = RoleAlias
        queryset = RoleAlias.objects.all()
        resource_name = 'rolealiases'
        allowed_methods = ['get']
        limit = 100
