# coding: utf-8


from idm.api.frontend import apifields
from idm.api.frontend.base import FrontendApiResource
from idm.core.models import RoleField


class RoleFieldResource(FrontendApiResource):
    """
    Ресурс поля узла дерева ролей
    """
    node = apifields.RoleNodeForeignKey()

    class Meta(FrontendApiResource.Meta):
        abstract = False
        object_class = RoleField
        queryset = RoleField.objects.all()
        resource_name = 'rolefields'
        allowed_methods = ['get']
        limit = 100
