from idm.api.frontend.serializers.base import Serializer, ListSerializer


class LightGroupSerializer(Serializer):
    db_fields = ['external_id']

    @classmethod
    def process_obj_fields(cls, obj, **kwargs):
        obj['id'] = obj.pop('external_id')


class LightNodeSerializer(Serializer):
    db_fields = ['value_path']


class LightUserSerializer(Serializer):
    db_fields = ['username']


class LightRoleSerializer(Serializer):
    db_fields = ['fields_data']

    complex_fields = {
        'group': LightGroupSerializer,
        'node': LightNodeSerializer,
        'user': LightUserSerializer,
    }


class LightRolesListSerializer(ListSerializer):
    obj_serializer = LightRoleSerializer
