# coding: utf-8

import logging
from typing import List, Dict, Any, Iterable

from django import forms
from django.db.models import Q
from django.http import HttpRequest

from idm.api.frontend.suggest.fields.usable_in_fields import UsableInFieldsSuggestResource
from idm.core.models.appmetrica import AppMetrica

logger = logging.getLogger(__name__)


class AppMetricaSuggestResource(UsableInFieldsSuggestResource):
    id_field = forms.IntegerField()
    id_field_name = 'application_id'

    class Meta(UsableInFieldsSuggestResource.Meta):
        resource_name = 'suggest/fields/app-metrica/all'
        queryset = AppMetrica.objects
        suggest_name = 'app_metrica'

    def filter_objects(self, objects: Iterable[AppMetrica], request: HttpRequest) -> Iterable[AppMetrica]:
        objects = super().filter_objects(objects, request)
        if self.query['q']:
            objects = objects.filter(
                Q(name__icontains=self.query['q']) | Q(application_id__istartswith=self.query['q'])
            )
        return objects

    def process_objects(self, objects: Iterable[AppMetrica], request) -> List[Dict[str, Any]]:
        return [{'id': app.application_id, 'name': app.name} for app in objects]
