# coding: utf-8


import logging

from django import forms

from idm.api.frontend.suggest.fields.usable_in_fields import UsableInFieldsSuggestResource
from idm.core.models import ConductorGroup

logger = logging.getLogger(__name__)


class ConductorGroupSuggestResource(UsableInFieldsSuggestResource):
    id_field = forms.CharField()
    id_field_name = 'name'

    class Meta(UsableInFieldsSuggestResource.Meta):
        resource_name = 'suggest/fields/conductor_groups/all'
        queryset = ConductorGroup.objects.active().order_by('external_id')
        suggest_name = 'conductor_groups'

    def filter_objects(self, objects, request):
        objects = super(ConductorGroupSuggestResource, self).filter_objects(objects, request)
        if self.query['q']:
            objects = objects.filter(name__icontains=self.query['q'])
        return objects

    def process_objects(self, objects, request):
        return [
            {
                'id': group.name,
                'name': group.name,
            }
            for group in objects
        ]
