# coding: utf-8


import logging

from django import forms

from idm.api.frontend.suggest.fields.usable_in_fields import UsableInFieldsSuggestResource
from idm.core.models import NetworkMacro

logger = logging.getLogger(__name__)


class MacroSuggestResource(UsableInFieldsSuggestResource):
    id_field = forms.CharField()
    id_field_name = 'slug'

    class Meta(UsableInFieldsSuggestResource.Meta):
        resource_name = 'suggest/fields/macros/all'
        queryset = NetworkMacro.objects.active().order_by('slug')
        suggest_name = 'macros'

    def filter_objects(self, objects, request):
        objects = super(MacroSuggestResource, self).filter_objects(objects, request)
        if self.query['q']:
            objects = objects.filter(slug__icontains=self.query['q'])
        return objects

    def process_objects(self, objects, request):
        return [
            {
                'id': macro.slug,
                'slug': macro.slug,
                'name': macro.slug,
            }
            for macro in objects
        ]
