# coding: utf-8


import logging
from typing import List, Dict, Any, Iterable

from django import forms
from django.db.models import Q
from django.http import HttpRequest

from idm.api.frontend.suggest.fields.usable_in_fields import UsableInFieldsSuggestResource
from idm.core.models.metrikacounter import MetrikaCounter

logger = logging.getLogger(__name__)


class MetrikaCounterSuggestResource(UsableInFieldsSuggestResource):
    id_field = forms.IntegerField()
    id_field_name = 'counter_id'

    class Meta(UsableInFieldsSuggestResource.Meta):
        resource_name = 'suggest/fields/metrika-counter/all'
        queryset = MetrikaCounter.objects
        suggest_name = 'metrika_counter'

    def filter_objects(self, objects: Iterable[MetrikaCounter], request: HttpRequest) -> Iterable[MetrikaCounter]:
        objects = super().filter_objects(objects, request)
        if self.query['q']:
            objects = objects.filter(Q(name__icontains=self.query['q']) | Q(counter_id__istartswith=self.query['q']))
        return objects

    def process_objects(self, objects: Iterable[MetrikaCounter], request) -> List[Dict[str, Any]]:
        return [{'id': counter.counter_id, 'name': counter.name} for counter in objects]
