# coding: utf-8


import abc
import logging
from tastypie import resources

from idm.api.frontend import forms
from idm.api.frontend.suggest.base import BaseSuggestResource


logger = logging.getLogger(__name__)

_REGISTRY = {}


class UsableInFieldsSuggestMetaclass(resources.ModelDeclarativeMetaclass):
    def __new__(typ, name, bases, attrs):
        new_class = super(UsableInFieldsSuggestMetaclass, typ).__new__(typ, name, bases, attrs)

        base_name = 'UsableInFieldsSuggestResource'
        meta = attrs.get('Meta')
        if meta is None:
            raise ValueError('Meta class must be specified')

        suggest_name = meta.suggest_name
        if suggest_name is None and name != base_name:
            raise ValueError('suggest_name must be specified in Meta')

        if suggest_name in _REGISTRY:
            raise ValueError('SuggestResource with name="{}" is already registered'.format(suggest_name))
        if suggest_name and not getattr(suggest_name, '__isabstractmethod__', False):
            _REGISTRY[suggest_name] = new_class

        return new_class


class UsableInFieldsSuggestResource(BaseSuggestResource, metaclass=UsableInFieldsSuggestMetaclass):
    """
    Для определения нового саджеста для поля suggestfield
    нужно специфицировать id_field (если оно поменялось)
    а также завести класс Meta и определить внутри resource_name, queryset/object_class, suggest_name
    """

    class Meta(BaseSuggestResource.Meta):
        form = forms.SuggestForm
        object_class = None
        suggest_name = None

    @classmethod
    def _get_queryset(cls):
        if hasattr(cls.Meta, 'queryset'):
            queryset = cls.Meta.queryset
        else:
            queryset = cls.Meta.object_class.objects.order_by(cls.id_field_name)
        return queryset

    @classmethod
    def get_object_list(cls, request, **kwargs):
        return cls._get_queryset()

    @classmethod
    def get_objects_by_id(cls, id):
        return list(cls._get_queryset().filter(**{cls.id_field_name: id}))

    @classmethod
    def get_fields(cls, *args, **kwargs):
        return {}
