# coding: utf-8

import importlib

import yenv
from django.urls import include, path, re_path

from idm.api.base import NotFoundView
from idm.api.testapi.yt import export_roles


def get_urls_by_api_name(name):
    module = importlib.import_module('idm.api.%s' % name)
    return re_path(r'^api/', include(module.api.urls))


urlpatterns = [get_urls_by_api_name('frontend'), get_urls_by_api_name('v1')]

if yenv.type != 'production':
    urlpatterns.append(get_urls_by_api_name('testapi'))  # REST API для тестировщиков

urlpatterns.append(path('api/export_roles/', export_roles, name='export_roles'))
urlpatterns.append(re_path(r'^api/', NotFoundView.as_view()))  # Всех остальных страниц нет
