from tastypie.api import Api

from idm.api.v1 import (
    action,
    approverequest,
    batch,
    batch_async,
    firewall,
    group,
    inconsistency,
    role,
    rolenode,
    rolerequest,
    status,
    system,
    transfer,
    user,
)

api = Api(api_name='v1')

api.register(action.ActionResource())
api.register(approverequest.ApproveRequestResource())
api.register(batch.BatchResource(api=api))
api.register(batch_async.BatchRoleRequestResource())
api.register(batch_async.BatchRoleDepriveResource())
api.register(firewall.FirewallResource())
api.register(group.GroupResource())
api.register(inconsistency.InconsistencyResource())
api.register(role.V1RoleResource())
api.register(rolenode.RoleNodeResource())
api.register(rolerequest.RoleRequestResource())
api.register(status.StatusResource())
api.register(system.SystemResource())
api.register(transfer.TransferResource())
api.register(user.UserResource())
