from django import forms
from django.utils.translation import ugettext_lazy as _
from idm.api.frontend import fields
from idm.api.frontend.forms import BaseForm, RoleRequestForm


class RequesterForm(BaseForm):
    _requester = fields.UserField(required=False, error_messages={
        'invalid_choice': _('Неизвестный запрашивающий роль.')
    })


class DelayedRoleRequestForm(RoleRequestForm):
    label = forms.CharField(required=True, max_length=64)


class DelayedRoleDepriveForm(BaseForm):
    id = fields.RoleField()
    comment = forms.CharField(required=False)
