# coding: utf-8


from idm.api.frontend.group import GroupResource as FrontendGroupResource

from .base import RequesterMixin


class GroupResource(RequesterMixin, FrontendGroupResource):
    """
    Ресурс группы
    """
    def dehydrate(self, bundle):
        bundle = super(GroupResource, self).dehydrate(bundle)
        bundle.data['name'] = {
            'ru': bundle.obj.name,
            'en': bundle.obj.name_en,
        }
        return bundle

    def dehydrate_for_detail(self, bundle):
        # переопределяем, чтобы не отдавать лишних данных
        return bundle
