# coding: utf-8
from django.http import HttpRequest

from idm.api.frontend.role import RoleResource
from idm.api.v1.base import RequesterMixin


class V1RoleResource(RequesterMixin, RoleResource):
    """
    Ресурс ролей
    """
    public_roles_only = False
    use_random_sorting_in_unwrap = False

    def get_object_list(self, request: HttpRequest, **kwargs):
        """Переопределим сортировку"""
        qs = super().get_object_list(request, **kwargs)
        qs = qs.order_by('pk')
        return qs
