from tastypie import fields

from idm.api.frontend.rolenode import RoleNodeResource as FrontendRoleNodeResource
from idm.api.v1.base import RequesterMixin
from idm.core.models import RoleNode


class RoleNodeResource(RequesterMixin, FrontendRoleNodeResource):
    """
    Ресурс узлов дерева ролей
    """
    parent_path = fields.CharField(attribute='parent_path', readonly=True, null=True)

    class Meta(FrontendRoleNodeResource.Meta):
        fields = FrontendRoleNodeResource.Meta.fields + ['created_at', 'updated_at']
        queryset = (
            RoleNode.objects
            .select_related(
                'parent',
                'system',
                'nodeset',
            )
            .prefetch_related(
                'fields',
                'aliases',
                'responsibilities',
                'responsibilities__user',
                'rolenodeclosure_parents',
            )
            .order_by('id')
        )

    def dehydrate(self, bundle):
        bundle = super(RoleNodeResource, self).dehydrate(bundle)
        data = bundle.obj.as_api()
        fieldnames = (
            'id',
            'state',
            'human',
            'human_short',
            'is_key',
            'system',
            'value_path',
            'parent_path',
            'unique_id',
            'created_at',
            'updated_at',
            'review_required',
            'comment_required',
        )
        for fieldname in fieldnames:
            data[fieldname] = bundle.data[fieldname]
        bundle.data = data
        return bundle
