# coding: utf-8


from idm.api.frontend.user import UserResource as FrontendUserResource

from .base import RequesterMixin


class UserResource(RequesterMixin, FrontendUserResource):
    """
    Ресурс пользователя
    """
    def dehydrate(self, bundle):
        bundle = super(UserResource, self).dehydrate(bundle)
        bundle.data['full_name'] = {
            'ru': bundle.obj.get_full_name(lang='ru'),
            'en': bundle.obj.get_full_name(lang='en'),
        }
        bundle.data['first_name'] = {
            'ru': bundle.obj.first_name,
            'en': bundle.obj.first_name_en,
        }
        bundle.data['last_name'] = {
            'ru': bundle.obj.last_name,
            'en': bundle.obj.last_name_en,
        }
        # TODO: пофиксить при переходе на staff api v3
        bundle.data['position'] = {
            'ru': bundle.obj.position,
            'en': bundle.obj.position,
        }
        return bundle

    def dehydrate_for_detail(self, bundle):
        # переопределяем, чтобы не отдавать лишних данных
        return bundle
