# coding: utf-8


from celery import Celery, signals

from django import db
from django.conf import settings


app = Celery('idm')

app.config_from_object(settings)
app.autodiscover_tasks(lambda: settings.INSTALLED_APPS)


def close_connection_if_task_is_not_eager(task, **kwargs):
    """
    Подчищаем протухшие соединения с базой перед запуском каждой задачи.
    В eager-тасках close_old_connection рушит внешнюю транзакцию, поэтому для них эта функция не выполняется"""

    if not task.request.is_eager:
        db.close_old_connections()

signals.task_prerun.connect(close_connection_if_task_is_not_eager)
