# coding: utf-8


from django.utils.translation import ugettext_lazy as _


MAX_ACTION_ERROR_LENGTH = 50000


class ACTION(object):
    # действия с ролями
    REQUEST = 'request'
    IGNORE = 'ignore'
    IMPORT = 'import'
    APPROVE = 'approve'
    DECLINE = 'decline'
    AWAIT = 'await'
    SENT = 'sent'
    GRANT = 'grant'
    HOLD = 'hold'
    DEPRIVE = 'deprive'
    REDEPRIVE = 'redeprive'
    FAIL = 'fail'
    IDM_ERROR = 'idm_error'
    EXPIRE = 'expire'
    REREQUEST = 'rerequest'
    RETRY_FAILED = 'retry_failed'
    ASK_REREQUEST = 'ask_rerequest'
    KEEP_GRANTED = 'keep_granted'
    REMOVE = 'remove'
    REMOTE_REMOVE = 'remote_remove'
    REVIEW_REREQUEST = 'review_rerequest'
    RESTORE = 'restore'
    APPLY_WORKFLOW = 'apply_workflow'
    RERUN_WORKFLOW = 'rerun_workflow'
    WORKFLOW_COMMENT = 'workflow_comment'
    CONFLICT_COMMENT = 'conflict_comment'
    START_DISCUSSION = 'start_discussion'
    MASS_ACTION = 'mass_action'
    FIRST_ADD_ROLE_PUSH = 'first_add_role_push'
    FIRST_REMOVE_ROLE_PUSH = 'first_remove_role_push'
    REF_ROLE_ERROR = 'ref_role_error'
    REVIEW_ROLE_ERROR = 'review_role_error'

    # действия с workflow
    CHANGE_WORKFLOW = 'change_workflow'

    # действия с неконсистентностями
    RESOLVE_INCONSISTENCY = 'resolve_inconsistency'

    # действия с системой
    STARTED_COMPARISON_WITH_SYSTEM = 'started_comparison_with_system'
    COMPARED_WITH_SYSTEM = 'compared_with_system'
    STARTED_SYNC_WITH_SYSTEM = 'started_sync_with_system'
    SYNCED_WITH_SYSTEM = 'synced_with_system'
    SYSTEM_MARKED_BROKEN = 'system_marked_broken'
    SYSTEM_MARKED_RECOVERED = 'system_marked_recovered'
    SYSTEM_CREATED = 'system_created'
    SYSTEM_UPDATED = 'system_updated'
    SYSTEM_SHUTDOWN = 'system_shutdown'

    # действия с деревом ролей
    UPDATE_ROLES_TREE = 'update_roles_tree'
    ROLE_TREE_STARTED_SYNC = 'role_tree_started_sync'
    ROLE_TREE_SYNCED = 'role_tree_synced'
    ROLE_TREE_SYNC_FAILED = 'role_tree_sync_failed'
    ROLE_NODE_CREATED = 'role_node_created'
    ROLE_NODE_CHANGED = 'role_node_changed'
    ROLE_NODE_MOVED = 'role_node_moved'
    ROLE_NODE_DELETED = 'role_node_deleted'
    ROLE_NODE_MARKED_DEPRIVING = 'role_node_marked_depriving'
    ROLE_NODE_ROLES_DEPRIVED = 'role_node_roles_deprived'
    ROLE_NODE_FIELD_CREATED = 'role_node_field_created'
    ROLE_NODE_FIELD_REMOVED = 'role_node_field_removed'
    ROLE_NODE_FIELD_CHANGED = 'role_node_field_changed'
    ROLE_NODE_ALIAS_CREATED = 'role_node_alias_created'
    ROLE_NODE_ALIAS_REMOVED = 'role_node_alias_removed'
    ROLE_NODE_RESPONSIBILITY_CREATED = 'role_node_responsibility_created'
    ROLE_NODE_RESPONSIBILITY_REMOVED = 'role_node_responsibility_removed'
    ROLE_NODE_RESPONSIBILITY_CHANGED = 'role_node_responsibility_changed'

    # действия с группой
    GROUP_CREATED = 'group_created'
    GROUP_MOVED = 'group_moved'
    GROUP_DELETED = 'group_deleted'
    GROUP_CHANGED = 'group_changed'

    # действия с сервисом
    SERVICE_CREATED = 'service_created'
    SERVICE_MOVED = 'service_moved'
    SERVICE_CHANGED = 'service_changed'
    SERVICE_REMOVED = 'service_removed'
    SERVICE_RESTORED = 'service_restored'

    # действия с AD
    USER_AD_UNKNOWN = 'user_ad_unknown'
    USER_AD_DISABLE = 'user_ad_disable'
    USER_AD_ENABLE = 'user_ad_enable'
    USER_AD_MOVE_TO_OLD = 'user_ad_move_to_old'
    USER_AD_MOVE_BACK = 'user_ad_move_back'
    USER_AD_ADD_TO_GROUP = 'user_ad_add_to_group'
    USER_AD_REMOVE_FROM_GROUP = 'user_ad_remove_from_group'
    USER_AD_RETURN_TO_GROUP = 'user_ad_return_to_group'

    # вход и выход из группы
    USER_CHANGE_DEPARTMENT = 'user_change_department'
    USER_JOINED_GROUP = 'user_joined_group'
    USER_QUIT_GROUP = 'user_quit_group'

    # смена ответственных группы
    GROUP_RESPONSIBLE_ADDED = 'group_responsible_added'
    GROUP_RESPONSIBLE_REMOVED = 'group_responsible_removed'

    # смена ответственных за пробота
    ROBOT_RESPONSIBLE_ADDED = 'robot_responsible_added'
    ROBOT_RESPONSIBLE_REMOVED = 'robot_responsible_removed'

    # Генерация отчета
    REPORT_REQUESTED = 'report_requested'

    # действия с паспортными логинами
    SUBSCRIBED = 'subscribed'
    UNSUBSCRIBED = 'unsubscribed'

    # действия с системочленствами
    SYSMEMBERSHIP_ACTIVATE = 'sysmembership_activate'
    SYSMEMBERSHIP_ACTIVATION_FAILED = 'sysmembership_activation_failed'
    SYSMEMBERSHIP_DEPRIVE = 'sysmembership_deprive'
    SYSMEMBERSHIP_DEPRIVATION_FAILED = 'sysmembership_deprivation_failed'
    SYSMEMBERSHIP_LOGIN_UPDATED = 'sysmembership_login_updated'
    SYSMEMBERSHIP_LOGIN_UPDATE_FAILED = 'sysmembership_login_update_failed'

    # действие с расхождениями в системочленствах
    GROUP_MEMBERSHIP_INCONSISTENCIES_RESOLVED = 'group_membership_inconsistencies_resolved'
    GROUP_MEMBERSHIP_INCONSISTENCIES_PUSH_FAILED = 'group_membership_inconsistency_push_failed'

    # действия с перемещениями
    TRANSFER_ACCEPTED = 'transfer_accepted'
    TRANSFER_REJECTED = 'transfer_rejected'
    TRANSFER_EXPIRED = 'transfer_expired'
    TRANSFERS_STARTED_DECISION = 'transfers_started_decision'
    TRANSFERS_DECIDED = 'transfers_decided'

    # синхронизация с Гэпом
    GAP_SYNCHRONIZATION_STARTED = 'gap_synchronization_started'
    GAP_SYNCHRONIZATION_COMPLETED = 'gap_synchronization_completed'

    # действия с организациями
    ORGANIZATION_CREATED = 'organization_created'
    ORGANIZATION_REMOVED = 'organization_removed'

    # действия с членствами в организациях
    USER_JOINED_ORGANIZATION = 'user_joined_organization'
    USER_QUIT_ORGANIZATION = 'user_quit_organization'

    # действия по синхронизации
    STARTED_MEMBERSHIP_SYNC = 'started_memberships_sync_with_system'
    FINISHED_MEMBERSHIP_SYNC = 'finished_memberships_sync_with_system'
    STARTED_MEMBERSHIP_PUSH = 'started_memberships_push_to_system'
    FINISHED_MEMBERSHIP_PUSH = 'finished_memberships_push_to_system'

    # дополнительные ACTION, которые можно сделать с ролью в карточке роли
    ADDITIONAL_ROLE_API_ACTIONS = {
        RETRY_FAILED,
    }

    ACTIONS = {
        # действия с ролями
        REQUEST: (_('запросил'), _('запросила'), _('запрос роли')),
        IGNORE: (_('воздержался'), _('воздержалась'), _('воздержание')),
        IMPORT: (_('импортировал'), _('импортировала'), _('импорт роли')),
        APPROVE: (_('подтвердил'), _('подтвердила'), _('подтверждение роли')),
        DECLINE: (_('отклонил'), _('отклонила'), _('отклонение выдачи роли')),
        AWAIT: (_('поставил в ожидание'), _('поставила в ожидание'), _('постановка в ожидание')),
        SENT: (_('роль передана в систему'),) * 3,
        GRANT: (_('выдал'), _('выдала'), _('выдача роли')),
        HOLD: (_('отложил'), _('отложила'), _('роль отложена')),
        DEPRIVE: (_('отозвал'), _('отозвала'), _('отзыв роли')),
        REDEPRIVE: (_('повторный отзыв роли'),) * 3,
        FAIL: (_('ошибка системы'), _('ошибка системы'), _('ошибка системы')),
        IDM_ERROR: (_('ошибка IDM'), _('ошибка IDM'), _('ошибка IDM')),
        EXPIRE: (_('роль просрочена'),) * 3,
        REREQUEST: (_('перезапросил'), _('перезапросила'), _('перезапрос роли')),
        RETRY_FAILED: (_('довыдал роль'), _('довыдала роль'), _('довыдача роли')),
        ASK_REREQUEST: (_('попроcил перезапросить'), _('попроcила перезапросить'), _('необходимость перезапроса')),
        KEEP_GRANTED: (_('оставил активной'), _('оставила активной'), _('оставление активной')),
        REMOVE: (_('удалил'), _('удалила'), _('удаление роли')),
        REMOTE_REMOVE: (_('удалил из системы'), _('удалила из системы'), _('удаление роли из системы')),
        REVIEW_REREQUEST: (_('перезапросил в связи с пересмотром'),
                             _('перезапросила в связи с регулярным пересмотром'),
                             _('перезапрос в связи с регулярным пересмотром')),
        RESTORE: (_('восстановил'), _('восстановила'), _('восстановление роли')),
        APPLY_WORKFLOW: (_('применил workflow'), _('применила воркфлоу'), _('применение воркфлоу')),
        RERUN_WORKFLOW: (_('переприменил workflow'), _('переприменила workflow'), _('переприменение workflow')),
        WORKFLOW_COMMENT: (_('прокомментировал'), _('прокомментировала'), _('комментарий')),
        CONFLICT_COMMENT: (_('прокомментировал конфликт'), _('прокомментировала конфликт'), _('комментарий о конфликте')),
        START_DISCUSSION: (_('начал обсуждение'), _('начала обсуждение'), _('начато обсуждение')),
        MASS_ACTION: (
            _('совершил массовое действие'),
            _('совершила массовое действие'),
            _('совершено массовое действие')
        ),
        REF_ROLE_ERROR: (
            _('получил ошибку при попытке выдать связанные роли'),
            _('получила ошибку при попытке выдать связанные роли'),
            _('произошла ошибка при попытке выдать связанные роли'),
        ),
        REVIEW_ROLE_ERROR: (
            _('получил ошибку при попытке пересмотра роли'),
            _('получила ошибку при попытке пересмотра роли'),
            _('произошла ошибка при попытке пересмотра роли'),
        ),

        # действия с workflow
        CHANGE_WORKFLOW: (_('изменил workflow'), _('изменила workflow'), _('изменение workflow')),

        # действия с неконсистентностями
        RESOLVE_INCONSISTENCY: (_('разрешил расхождение'),
                                  _('разрешила расхождение'),
                                  _('разрешение расхождения')),

        # действия с системой
        STARTED_COMPARISON_WITH_SYSTEM: (_('запустил сравнение ролей с системой'),
                                           _('запустила сравнение ролей с системой'),
                                           _('запуск сравнения ролей с системой')),
        COMPARED_WITH_SYSTEM: (_('завершил сравнение ролей с системой'),
                                 _('завершила сравнение ролей с системой'),
                                 _('завершение сравнения ролей с системой')),
        STARTED_SYNC_WITH_SYSTEM: (_('запустил разрешение расхождений'),
                                     _('запустила разрешение расхождений'),
                                     _('запуск разрешения расхождений')),
        SYNCED_WITH_SYSTEM: (_('завершил разрешение расхождений'),
                               _('завершила разрешение расхождений'),
                               _('завершение разрешения расхождений')),

        SYSTEM_MARKED_BROKEN: (_('пометил систему сломанной'),
                                 _('пометила систему сломанной'),
                                 _('система помечена как сломанная')),
        SYSTEM_MARKED_RECOVERED: (_('пометил систему починенной'),
                                    _('пометила систему починенной'),
                                    _('система помечена как починенная')),
        SYSTEM_CREATED: (_('создал систему'),
                           _('создала систему'),
                           _('система была создана')),
        SYSTEM_UPDATED: (_('обновил систему'),
                         _('обновила систему'),
                         _('система была обновлена')),
        SYSTEM_SHUTDOWN: (_('выключил систему'),
                         _('выключила систему'),
                         _('система была выключена')),

        # действия с деревом ролей
        UPDATE_ROLES_TREE: (_('[old] запустил обновление дерева ролей'), _('[old] запустила обновление дерева ролей'),
                              _('[old] запуск обновления дерева ролей')),
        ROLE_TREE_STARTED_SYNC: (_('запустил обновление дерева ролей'), _('запустила обновление дерева ролей'),
                                   _('запуск обновления дерева ролей')),
        ROLE_TREE_SYNCED: (_('завершил обновление дерева ролей'), _('завершила обновление дерева ролей'),
                             _('завершение обновления дерева ролей')),
        ROLE_TREE_SYNC_FAILED: (
            _('прервал обновление дерева ролей из-за ошибки'),
            _('прервала обновление дерева ролей из-за ошибки'),
            _('возникла ошибка при обновлении дерева ролей'),
        ),
        ROLE_NODE_CREATED: (_('добавил узел дерева ролей'), _('добавила узел дерева ролей'),
                              _('добавление узла дерева ролей')),
        ROLE_NODE_CHANGED: (_('изменил узел дерева ролей'), _('изменила узел дерева ролей'),
                              _('изменение узла дерева ролей')),
        ROLE_NODE_MOVED: (_('переместил узел дерева ролей'), _('переместила узел дерева ролей'),
                            _('перемещение узла дерева ролей')),
        ROLE_NODE_DELETED: (_('удалил узел дерева ролей'), _('удалила узел дерева ролей'),
                              _('удаление узла дерева ролей')),
        ROLE_NODE_MARKED_DEPRIVING: (_('пометил для удаления узел дерева ролей'),
                                       _('пометила для удаления узел дерева ролей'),
                                       _('пометка для удаления узла дерева ролей')),
        ROLE_NODE_ROLES_DEPRIVED: (_('удалил все роли для узла дерева ролей'),
                                     _('удалила все роли для узла дерева ролей'),
                                     _('удаление всех ролей для узла дерева ролей')),
        ROLE_NODE_FIELD_CREATED: (_('добавил поле к узлу дерева ролей'), _('добавила поле к узлу дерева ролей'),
                                    _('добавление поля к узлу дерева ролей')),
        ROLE_NODE_FIELD_REMOVED: (_('удалил поле узла дерева ролей'),
                                    _('удалила поле узла дерева ролей'),
                                    _('удаление поля узла дерева ролей')),
        ROLE_NODE_FIELD_CHANGED: (_('изменил поле узла дерева ролей'),
                                    _('изменила поле узла дерева ролей'),
                                    _('изменение поля узла дерева ролей')),
        ROLE_NODE_ALIAS_CREATED: (_('добавил синоним узла дерева ролей'),
                                    _('добавила синоним узлу дерева ролей'),
                                    _('добавление синонима узла дерева ролей')),
        ROLE_NODE_ALIAS_REMOVED: (_('удалил синоним узла дерева ролей'), _('удалила синоним узла дерева ролей'),
                                    _('удаление синонима узла дерева ролей')),
        ROLE_NODE_RESPONSIBILITY_CREATED: (_('добавил ответственного узлу дерева ролей'),
                                             _('добавила ответственного узлу дерева ролей'),
                                             _('добавление ответственного узлу дерева ролей')),
        ROLE_NODE_RESPONSIBILITY_REMOVED: (_('удалил ответственного узла дерева ролей'),
                                             _('удалила ответственного узла дерева ролей'),
                                             _('удаление ответственного узла дерева ролей')),
        ROLE_NODE_RESPONSIBILITY_CHANGED: (_('изменил ответственного узла дерева ролей'),
                                             _('изменила ответственного узла дерева ролей'),
                                             _('изменение ответственного узла дерева ролей')),

        # действия с группой
        GROUP_CREATED: (_('добавил группу пользователей'),
                          _('добавила группу пользователей'),
                          _('добавление группы пользователей')),
        GROUP_MOVED: (_('переместил группу пользователей'),
                        _('переместила группу пользователей'),
                        _('перемещение группы пользователей')),
        GROUP_DELETED: (_('удалил группу пользователей'),
                          _('удалила группу пользователей'),
                          _('удаление группы пользователей')),
        GROUP_CHANGED: (_('изменил группу пользователей'),
                          _('изменила группу пользователей'),
                          _('изменение группы пользователей')),

        # действия с сервисом
        SERVICE_CREATED: (_('добавил сервис'), _('добавила сервис'), _('добавление сервиса')),
        SERVICE_MOVED: (_('переместил сервис'), _('переместила сервис'), _('перемещение сервиса')),
        SERVICE_CHANGED: (_('изменил сервис'), _('изменила сервис'), _('изменение сервиса')),
        SERVICE_REMOVED: (_('удалил сервис'), _('удалила сервис'), _('удаление сервиса')),
        SERVICE_RESTORED: (_('восстановил сервис'), _('восстановила сервис'), _('восстановление сервиса')),

        # действия с AD
        # тип действий user_ad_unknown существует, так как у старых записей нет более точной информации о действии
        USER_AD_UNKNOWN: (_('выполнил действие с AD'), _('выполнила действие с AD'), _('действие с AD')),
        USER_AD_DISABLE: (_('деактивировал аккаунт в AD'),
                            _('деактивировала аккаунт в AD'),
                            _('деактивирован аккаунт в AD')),
        USER_AD_ENABLE: (_('активировал аккаунт в AD'),
                           _('активировала аккаунт в AD'),
                           _('активирован аккаунт в AD')),
        USER_AD_MOVE_TO_OLD: (_('перенёс в Old Users'), _('перенесла в Old Users'), _('перенос в Old Users')),
        USER_AD_MOVE_BACK: (_('восстановил из Old Users'),
                              _('восстановила из Old Users'),
                              _('восстановление из Old Users')),
        USER_AD_ADD_TO_GROUP: (_('добавил в AD-группу'), _('добавила в AD-группу'), _('добавление в AD-группу')),
        USER_AD_REMOVE_FROM_GROUP: (_('удалил из AD-группы'), _('удалила из AD-группы'), _('удаление из AD-группы')),
        USER_AD_RETURN_TO_GROUP: (_('вернул в AD-группу'), _('вернула в AD-группу'), _('возвращение в AD-группу')),

        # смена департамента
        USER_CHANGE_DEPARTMENT: (_('сменил отдел'), _('сменила отдел'), _('смена отдела')),

        # вход и выход из группы
        USER_JOINED_GROUP: (_('присоединился к группе'),
                              _('присоединилась к группе'),
                              _('присоединение к группе')),
        USER_QUIT_GROUP: (_('покинул группу'),
                            _('покинула группу'),
                            _('выход из группы')),

        # смена ответственных группы
        GROUP_RESPONSIBLE_ADDED: (_('стал ответственным группы'),
                                    _('стала ответственной группы'),
                                    _('добавление ответственного группы')),
        GROUP_RESPONSIBLE_REMOVED: (_('перестал быть ответственным группы'),
                                      _('перестала быть ответственной группы'),
                                      _('удаление ответственного группы')),
        # смена ответственных роботов
        ROBOT_RESPONSIBLE_ADDED: (_('стал владельцем робота'),
                                    _('стала владельцем робота'),
                                    _('добавление владельца робота')),
        ROBOT_RESPONSIBLE_REMOVED: (_('перестал быть владельцем робота'),
                                      _('перестала быть владельцем робота'),
                                      _('удаление владельца робота')),
        # Генерация отчета
        REPORT_REQUESTED: (_('заказал отчет'),
                             _('заказала отчет'),
                             _('заказан отчет')),
        # действия с паспортными логинами
        SUBSCRIBED: (_('подписал логин'), _('подписала логин'), _('подписан логин')),
        UNSUBSCRIBED: (_('снял подписку с логина'), _('сняла подписку с логина'), _('снята подписка с логина')),

        # действия с системочленствами
        SYSMEMBERSHIP_ACTIVATE: (_('активация'),) * 3,
        SYSMEMBERSHIP_ACTIVATION_FAILED: (_('активация не удалась'),) * 3,
        SYSMEMBERSHIP_DEPRIVE: (_('удаление'),) * 3,
        SYSMEMBERSHIP_DEPRIVATION_FAILED: (_('удаление не удалось'),) * 3,
        SYSMEMBERSHIP_LOGIN_UPDATED: (_('обновил логин'), _('обновила логин'), _('обновлен логин')),
        SYSMEMBERSHIP_LOGIN_UPDATE_FAILED: (_('обновление логина не удалось'),) * 3,

        # действие с расхождениями в системочленствах
        GROUP_MEMBERSHIP_INCONSISTENCIES_RESOLVED: (
            _('разрешил расхождения в составе групп'),
            _('разрешила расхождения в составе групп'),
            _('расхождения в составе групп разрешены'),
        ),
        GROUP_MEMBERSHIP_INCONSISTENCIES_PUSH_FAILED: (_('разрешение расхождений в составе групп не удалось'),) * 3,

        # действия с перемещениями (transfer)
        TRANSFER_ACCEPTED: (_('признал существенным'), _('признала существенным'), _('признано существенным')),
        TRANSFER_REJECTED: (_('признал несущественным'), _('признала несущественным'), _('признано несущественным')),
        TRANSFER_EXPIRED: (_('перемещение устарело'),) * 3,
        TRANSFERS_STARTED_DECISION: (
            _('запустил разрешение перемещений'),
            _('запустила разрешение перемещений'),
            _('запуск разрешения перемещений')
        ),
        TRANSFERS_DECIDED: (
            _('завершил разрешение перемещений'),
            _('завершила разрешение перемещений'),
            _('завершение разрешения перемещений')
        ),

        # синхронизация с Гэпом
        GAP_SYNCHRONIZATION_STARTED: (_('синхронизация с Гэпом началась'),) * 3,
        GAP_SYNCHRONIZATION_COMPLETED: (_('синхронизация с Гэпом завершилась'),) * 3,

        ORGANIZATION_CREATED: (_('создал организацию'), _('создала организацию'), _('создание организации')),
        ORGANIZATION_REMOVED: (_('удалил организацию'), _('удалила организацию'), _('удаленине организации')),

        USER_JOINED_ORGANIZATION: (
            _('присоединился к организации'), _('присоединилась к организации'), _('присоединение к организации')
        ),
        USER_QUIT_ORGANIZATION: (_('покинул организацию'), _('покинула организацию'), _('выход из организации')),
        STARTED_MEMBERSHIP_SYNC: (
            _('запустил синхронизацию членств'),
            _('запустила синхронизацию членств'),
            _('запуск синхронизации членств'),
        ),
        FINISHED_MEMBERSHIP_SYNC: (
            _('завершил синхронизацию членств'),
            _('завершила синхронизацию членств'),
            _('завершение синхронизации членств'),
        ),
        STARTED_MEMBERSHIP_PUSH: (
            _('запустил отправку членств в систему'),
            _('запустила отправку членств в систему'),
            _('запуск отправки членств в систему'),
        ),
        FINISHED_MEMBERSHIP_PUSH: (
            _('завершил отправку членств в систему'),
            _('завершила отправку членств в систему'),
            _('завершение отправки членств в систему'),
        ),

        FIRST_ADD_ROLE_PUSH: (
            _('первый раз попытался добавить роль в систему'),
            _('первый раз попыталась добавить роль в систему'),
            _('первая попытка добавить роль в систему'),
        ),
        FIRST_REMOVE_ROLE_PUSH: (
            _('первый раз попытался удалить роль из системы'),
            _('первый раз попыталась удалить роль из системы'),
            _('первая попытка удалить роль из системы'),
        ),
    }


class ACTION_DATA_KEYS(object):
    FORCE_DEPRIVE = 'force_deprive'
    ACTION_STATE = 'action_state'


class ACTION_STATE(object):
    BEGIN = 'begin'
    COMPLETED = 'completed'
    FAILED = 'failed'

    FINISHED_STATES = {COMPLETED, FAILED}
