# coding: utf-8


import attr

from django.utils.translation import ugettext as _


@attr.s
class TEMPLATE_TYPES(object):
    SELF_USER = 'self_user'
    INTERNAL_HEAD = 'internal_head'
    ROBOT = 'robot'
    GROUP = 'group'


NOT_FULLY_REGISTERED_PASSPORT_LOGINS_TEMPLATES = {
    TEMPLATE_TYPES.SELF_USER: (
        _('Некоторые паспортные логины необходимо дорегистрировать'),
        'emails/not_fully_registered_passport_logins/user.txt'
    ),
    TEMPLATE_TYPES.ROBOT: (
        _('Некоторые паспортные логины %s необходимо дорегистрировать'),
        'emails/not_fully_registered_passport_logins/robot.txt'
    )
}

EXPIRATION_ROLES_TEMPLATES = {
    TEMPLATE_TYPES.INTERNAL_HEAD: (
        _('Некоторые роли %s требуют повторного подтверждения'),
        'emails/expiration/external_user_roles.txt',
    ),
    TEMPLATE_TYPES.ROBOT: (
        _('Некоторые роли %s требуют повторного подтверждения'),
        'emails/expiration/robot_roles.txt',
    ),
    TEMPLATE_TYPES.SELF_USER: (
        _('Некоторые роли требуют повторного подтверждения'),
        'emails/expiration/user_roles.txt',
    ),
    TEMPLATE_TYPES.GROUP: (
        _('Некоторые роли %s требуют подтверждения'),
        'emails/expiration/group_roles.txt'
    ),
}

REREQUESTED_ROLES_TEMPLATES = {
    TEMPLATE_TYPES.INTERNAL_HEAD: (
        _('Некоторые перезапрошенные роли %s не подтверждены и скоро будут отозваны'),
        'emails/rerequested/external_user_roles.txt'
    ),
    TEMPLATE_TYPES.ROBOT: (
        _('Некоторые перезапрошенные роли %s не подтверждены и скоро будут отозваны'),
        'emails/rerequested/robot_roles.txt',
    ),
    TEMPLATE_TYPES.SELF_USER: (
        _('Некоторые перезапрошенные роли не подтверждены и скоро будут отозваны'),
        'emails/rerequested/internal_user_roles.txt',
    ),
    TEMPLATE_TYPES.GROUP: (
        _('Некоторые перезапрошенные роли %s не подтверждены и скоро будут отозваны'),
        'emails/rerequested/group_roles.txt'
    ),
}

ONHOLD_ROLES_TEMPLATES = {
    TEMPLATE_TYPES.INTERNAL_HEAD: (
        _('Некоторые роли %s скоро будут отозваны'),
        'emails/onhold/external_user_roles.txt',
    ),
    TEMPLATE_TYPES.ROBOT: (
        _('Некоторые роли %s скоро будут отозваны'),
        'emails/onhold/robot_roles.txt',
    ),
    TEMPLATE_TYPES.SELF_USER: (
        _('Некоторые роли скоро будут отозваны'),
        'emails/onhold/user_roles.txt',
    ),
}

PASSPORT_LOGIN_NEED_ATTACH_REGULAR_TEMPLATES = {
        TEMPLATE_TYPES.INTERNAL_HEAD: (
            _('Участие в некоторых группах %s требует указания паспортного логина'),
            'emails/membership_passport_login/regular_reminder/external_user_roles.txt',
        ),
        TEMPLATE_TYPES.ROBOT: (
            _('Участие в некоторых группах %s требует указания паспортного логина'),
            'emails/membership_passport_login/regular_reminder/robot_roles.txt',
        ),
        TEMPLATE_TYPES.SELF_USER: (
            _('Участие в некоторых группах требует указания паспортного логина'),
            'emails/membership_passport_login/regular_reminder/user_roles.txt',
        ),
    }

PASSPORT_LOGIN_NEED_ATTACH_NEW_GROUP_ROLE_TEMPLATES = {
        TEMPLATE_TYPES.INTERNAL_HEAD: (
            _('Участие в группе пользователя %s требует указания паспортного логина'),
            'emails/membership_passport_login/new_group_role_is_system_aware_for_membership/external_user_roles.txt',
        ),
        TEMPLATE_TYPES.ROBOT: (
            _('Участие в группе робота %s требует указания паспортного логина'),
            'emails/membership_passport_login/new_group_role_is_system_aware_for_membership/robot_roles.txt',
        ),
        TEMPLATE_TYPES.SELF_USER: (
            _('Участие в группе требует указания паспортного логина'),
            'emails/membership_passport_login/new_group_role_is_system_aware_for_membership/user_roles.txt',
        ),
    }

PASSPORT_LOGIN_NEED_ATTACH_NEW_MEMBER_TEMPLATES = {
        TEMPLATE_TYPES.INTERNAL_HEAD: (
            _('Участие в группе пользователя %s требует указания паспортного логина'),
            'emails/membership_passport_login/new_member_in_group/external_user_roles.txt',
        ),
        TEMPLATE_TYPES.ROBOT: (
            _('Участие в группе робота %s требует указания паспортного логина'),
            'emails/membership_passport_login/new_member_in_group/robot_roles.txt',
        ),
        TEMPLATE_TYPES.SELF_USER: (
            _('Участие в группе требует указания паспортного логина'),
            'emails/membership_passport_login/new_member_in_group/user_roles.txt',
        ),
    }
