# coding: utf-8


import attr

from django.utils.translation import ugettext_lazy as _
from model_utils import Choices


@attr.s
class MEMBERSHIP_SYSTEM_RELATION_STATE(object):
    """
    activating - создано новое членство, либо старое неактивное вновь стало активным, нужно сообщить системе
    activated - активное членство отправлено в систему и получен ответ, что система его приняла
    depriving - существующее членство стало неактивным, нужно сообщить системе
    deprived - неактивное членство отправлено в систему и получен ответ, что система его приняла
    hold - отложенный выход, системе пока ничего не сообщаем
    failed - произошла какая-то ошибка
    """

    ACTIVATING = 'activating'
    ACTIVATED = 'activated'
    DEPRIVING = 'depriving'
    DEPRIVED = 'deprived'
    HOLD = 'hold'
    FAILED = 'failed'

    STATUSES = [
        ACTIVATING,
        ACTIVATED,
        DEPRIVING,
        DEPRIVED,
        HOLD,
        FAILED,
    ]

    NAMES = (
        (ACTIVATING, _('Активируется')),
        (ACTIVATED, _('Активно, передано в систему')),
        (DEPRIVING, _('Отзывается')),
        (DEPRIVED, _('Отозвано, передано в систему')),
        (HOLD, _('Отложено')),
        (FAILED, _('Ошибка')),
    )

    # Состояния, из которых возможен переход в activating
    CAN_BE_ACTIVATED_STATES = {DEPRIVING, DEPRIVED, HOLD, FAILED}
    # Состояния, из которых возможен переход в hold
    CAN_BE_PUT_ON_HOLD_STATES = {ACTIVATING, ACTIVATED, FAILED}
    # Состояния, из которых возможен переход в depriving
    CAN_BE_PUT_ON_DEPRIVING_STATES = {ACTIVATING, ACTIVATED, HOLD, FAILED}
    # Состояния, при которых пушим изменения в систему
    PUSHABLE_STATES = {ACTIVATING, ACTIVATED, DEPRIVING, HOLD}
    # Состояния, из которых можно попасть в ACTIVATED
    CAN_BE_ACTIVE_STATES = {ACTIVATED, ACTIVATING, HOLD}

@attr.s
class GROUPMEMBERSHIP_INCONSISTENCY_STATE(object):
    CREATED = 'created'
    ACTIVE = 'active'
    MATCHING = 'matching'
    RESOLVED = 'resolved'
    OBSOLETE = 'obsolete'
    PAIRED = 'paired'


@attr.s
class GROUPMEMBERSHIP_INCONSISTENCY_TYPE(object):
    WE_HAVE_SYSTEM_DONT = 'we_have_system_dont'
    SYSTEM_HAS_WE_DONT = 'system_has_we_dont'
    UNDECIDED = 'undecided'


@attr.s
class GROUPMEMBERSHIP_INCONSISTENCY(object):
    TYPES = Choices(
        (GROUPMEMBERSHIP_INCONSISTENCY_TYPE.WE_HAVE_SYSTEM_DONT, 'OUR', _('У нас есть членство, в системе – нет')),
        (GROUPMEMBERSHIP_INCONSISTENCY_TYPE.SYSTEM_HAS_WE_DONT, 'THEIR', _('В системе есть членство, у нас – нет')),
        (GROUPMEMBERSHIP_INCONSISTENCY_TYPE.UNDECIDED, 'UNDECIDED', _('Тип еще не определен')),
    )

    STATES = Choices(
        (GROUPMEMBERSHIP_INCONSISTENCY_STATE.CREATED, 'CREATED', _('Создана')),
        (GROUPMEMBERSHIP_INCONSISTENCY_STATE.ACTIVE, 'ACTIVE', _('Активна')),
        (GROUPMEMBERSHIP_INCONSISTENCY_STATE.MATCHING, 'MATCHING', _('Совпадение')),
        (GROUPMEMBERSHIP_INCONSISTENCY_STATE.RESOLVED, 'RESOLVED', _('Разрешена')),
        (GROUPMEMBERSHIP_INCONSISTENCY_STATE.OBSOLETE, 'OBSOLETE', _('Устарела')),
        (GROUPMEMBERSHIP_INCONSISTENCY_STATE.PAIRED, 'PAIRED',
         _('Имеет парную неконсистентность с другим паспортным логином')
         )
    )
