
# Список шагов сверки ролей
class INCONSISTENCY_AUDIT_STEPS:
    # Получение ролей из системы
    GET_ROLES = 'get_roles'

    # Запишем роли системы, как расхождения
    INSERT_INCONSISTENCIES = 'insert_inconsistencies'

    # Линкуем роли системы с узлами по data или path
    LINK_BY_IDENTITY = 'link_by_identity'

    # Для расхождений из-за неизвестных юзеров/групп проставляем узлы, если они есть
    UPDATE_UNKNOWN_SUBJECT_NODES = 'update_unknown_subject_nodes'

    # Для неслинкованных ролей создадим расхождения типа "неизвестный узел", остальное подготовим для сравнения
    SET_UNKNOWN_NODE_FOR_UNLINKED = 'set_unknown_node_for_unlinked'

    # Подготовим роли IDM для сравнения
    PREPARE_ACTIVE_ROLES = 'prepare_active_roles'

    # Найдём все роли, которые есть только у нас
    CREATE_OURS = 'create_ours'

    # Найдём все роли, которые есть только в системе
    CREATE_THEIRS = 'create_theirs'

    INCONSISTENCY_PROCESSOR_STEPS = [
        LINK_BY_IDENTITY,
        UPDATE_UNKNOWN_SUBJECT_NODES,
        SET_UNKNOWN_NODE_FOR_UNLINKED,
        PREPARE_ACTIVE_ROLES,
        CREATE_OURS,
        CREATE_THEIRS,
    ]

    ALL_STEPS = set(INCONSISTENCY_PROCESSOR_STEPS) | {GET_ROLES, INSERT_INCONSISTENCIES}
