# coding: utf-8

import attr
from django.http import response


@attr.s
class INTRASEARCH_METHOD(object):
    ADD = 'add'
    MODIFY = 'modify'
    REMOVE = 'remove'

    NAMES = (
        (ADD, ADD),
        (MODIFY, MODIFY),
        (REMOVE, REMOVE),
    )

    TO_HTTP = {
        ADD: 'post',
        MODIFY: 'post',
        REMOVE: 'delete',
    }

    @classmethod
    def as_http(cls, method):
        return cls.TO_HTTP[method]

    @classmethod
    def should_serialize(cls, method):
        return method != cls.REMOVE


@attr.s
class INTRASEARCH_STATE(object):
    DIRTY = 'dirty'
    GOOD = None

    NAMES = (
        (DIRTY, 'Dirty'),
        (GOOD, 'Good'),
    )
