# coding: utf-8


from django.utils.translation import ugettext_lazy as _


class PASSPORT_LOGIN_STATE(object):
    NEW = 'new'
    CREATED = 'created'
    SUBSCRIBED = 'subscribed'
    UNSUBSCRIBED = 'unsubscribed'
    UNKNOWN = 'unknown'  # попал случайно, из системы

    CHOICES = (
        (NEW, _('Новый')),
        (CREATED, _('Создан')),
        (SUBSCRIBED, _('Подписка установлена')),
        (UNSUBSCRIBED, _('Подписка удалена')),
        (UNKNOWN, _('Неизвестен')),
    )


class CREATED_FLAG_REASON(object):
    HISTORY = 'history'
    DELTA = 'delta'
    MANUAL = 'manual'
    EXACT = 'exact'

    CHOICES = (
        (HISTORY, _('Паспортные логи в YT или наши Action-ы')),
        (DELTA, _('Разница между регистрацией логина и создания у нас <10 секунд')),
        (MANUAL, _('Проставлено руками')),
        (EXACT, _('Точно знаем: проставили мы сами')),
    )
