# coding: utf-8


from django.utils.timezone import datetime
from django.utils.translation import ugettext_lazy as _

NOT_NOTIFY_ON_REGISTER_PASSPORT_LOGINS_TO = datetime(2019, 3, 27)
MAX_ROLE_TTL_DAYS = 365


class ROLE_STATE(object):
    CREATED = 'created'
    IMPORTED = 'imported'
    REQUESTED = 'requested'
    APPROVED = 'approved'
    AWAITING = 'awaiting'
    SENT = 'sent'
    DEPRIVED = 'deprived'
    FAILED = 'failed'
    IDM_ERROR = 'idm_error'
    EXPIRING = 'expiring'
    EXPIRED = 'expired'
    DECLINED = 'declined'
    REREQUESTED = 'rerequested'
    NEED_REQUEST = 'need_request'
    ONHOLD = 'onhold'
    GRANTED = 'granted'
    DEPRIVING = 'depriving'
    DEPRIVING_VALIDATION = 'depriving_validation'
    REVIEW_REQUEST = 'review_request'

    STATE_CHOICES = {
        CREATED: _('Создана'),
        IMPORTED: _('Импортирована'),
        REQUESTED: _('Запрошена'),
        APPROVED: _('Подтверждена'),
        AWAITING: _('Ожидание'),
        SENT: _('Передана в систему'),
        DEPRIVED: _('Отозвана'),
        FAILED: _('Ошибка системы'),
        IDM_ERROR: _('Ошибка IDM'),
        EXPIRING: _('Истекает'),
        EXPIRED: _('Просрочена'),
        DECLINED: _('Отклонена'),
        REREQUESTED: _('Перезапрошена'),
        NEED_REQUEST: _('Нужно перезапросить'),
        ONHOLD: _('Отложена'),
        GRANTED: _('Выдана'),
        DEPRIVING: _('Отзывается'),
        DEPRIVING_VALIDATION: _('Валидация отзыва'),
        REVIEW_REQUEST: _('Перезапрошена в связи с регулярным пересмотром'),
    }
    ALL_STATES = set(STATE_CHOICES.keys())
    # состояния, в которых роль активна (с точки зрения системы и с точки зрения флага is_active у нас)
    ACTIVE_STATES = {
        REREQUESTED, IMPORTED, NEED_REQUEST, GRANTED, DEPRIVING, DEPRIVING_VALIDATION, REVIEW_REQUEST, ONHOLD, EXPIRING
    }
    # состояния, в которых роль "почти активна": например, владелец такой роли может подтверждать другие роли
    ALMOST_ACTIVE_STATES = ACTIVE_STATES - {DEPRIVING} | {APPROVED, AWAITING}
    # состояния, из которых мы должны сделать пуш в систему
    DEPRIVABLE_STATES = ACTIVE_STATES | {SENT}
    # в этих состояниях роль *ещё* неактивна
    NOT_YET_ACTIVE_STATES = {CREATED, REQUESTED, APPROVED, AWAITING, SENT}
    # в этих состояниях роль *уже* неактивна
    ALREADY_INACTIVE_STATES = {DEPRIVED, FAILED, IDM_ERROR, EXPIRED, DECLINED}
    # все неактивные состояния
    INACTIVE_STATES = NOT_YET_ACTIVE_STATES | ALREADY_INACTIVE_STATES
    # состояния, из которых потенциально можно вернуться в granted
    RETURNABLE_STATES = {REQUESTED, APPROVED, AWAITING, GRANTED, REVIEW_REQUEST, NEED_REQUEST,
                         REREQUESTED, SENT, IMPORTED, ONHOLD, DEPRIVING_VALIDATION, CREATED, EXPIRING}
    # активные состояния, из которых потенциально можно вернуться в granted
    # этот набор эквивалентен ACTIVE_STATES, за исключением того, что в нём нет depriving
    ACTIVE_RETURNABLE_STATES = RETURNABLE_STATES & ACTIVE_STATES

    # состояния, из которых можно перезапросить роль
    REREQUESTABLE_STATES = {REQUESTED, NEED_REQUEST, REREQUESTED, EXPIRING} | ALREADY_INACTIVE_STATES
    # состояния, из которых можно перезапросить связанную роль
    REF_REREQUESTABLE_STATES = RETURNABLE_STATES | {DEPRIVED, FAILED, IDM_ERROR}
    # состояния, из которых перезапросить роль может только суперпользователь
    AUTHORITY_REREQUESTABLE_STATES = {GRANTED}

    # состояния, в которых роль считается запрошенной
    REQUESTED_STATES = {REQUESTED, REREQUESTED, IMPORTED, REVIEW_REQUEST, APPROVED, AWAITING, SENT}

    # состояния, в которых можно обсуждать роль
    STATES_FOR_DISCUSSION = {REQUESTED, REREQUESTED, REVIEW_REQUEST}

    # состояния, в которых мы не отсылаем оповещения при тихих запросах
    SILENCABLE_STATES = {REQUESTED, GRANTED}

    # переходы, разрешённые в сломанных системах
    INNER_TRANSITIONS = {
        (GRANTED, ONHOLD),
        (GRANTED, NEED_REQUEST),
        (GRANTED, GRANTED),
    }
    # сделаем переходы симметричными
    INNER_TRANSITIONS |= {(to_state, from_state) for (from_state, to_state) in INNER_TRANSITIONS}

    # состояния, в которых рассылаем напоминания, если до протухания осталось IDM_REMIND_ABOUT_REREQUESTED_ROLES_DAYS
    REMINDER_ABOUT_UPCOMING_DEPRIVED_STATES = {REREQUESTED, REVIEW_REQUEST, IMPORTED}

    # состояния, для которых рисуем на фронте кнопку "Отозвать"
    CAN_BE_DEPRIVING_API_STATES = RETURNABLE_STATES - {APPROVED}

    # состояния, из которых возможен переход в depriving
    CAN_BE_DEPRIVING_STATES = CAN_BE_DEPRIVING_API_STATES | {DEPRIVING, DEPRIVING_VALIDATION}
